/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.UncheckedException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Functions {
    private Functions() {
    }

    public static <T, E extends Throwable> Supplier<T> unchecked(CheckedSupplier<T, E> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <E extends Throwable> Runnable unchecked(CheckedRunnable<E> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, E extends Throwable> Consumer<T> unchecked(CheckedConsumer<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, U, E extends Throwable> BiConsumer<T, U> unchecked(CheckedBiConsumer<T, U, E> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, U, E extends Throwable> Function<T, U> unchecked(CheckedFunction<T, U, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static RuntimeException wrap(Throwable ex) {
        if (ex instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)ex;
            return runtimeException;
        }
        return new UncheckedException(ex);
    }

    public static Throwable unwrap(Throwable ex) {
        if (ex instanceof UncheckedException) {
            return ex.getCause();
        }
        return ex;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface CheckedRunnable<E extends Throwable> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, U, E extends Throwable> {
        public U apply(T var1) throws E;
    }
}

