/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.Size;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;

class SizeImpl
implements Size {
    private final BigInteger bytes;

    SizeImpl(BigInteger bytes) {
        this.bytes = bytes;
    }

    @Override
    public BigDecimal to(Size.Unit unit) {
        Objects.requireNonNull(unit, "Unit must not be null");
        BigDecimal bigDecimal = new BigDecimal(unit.bytesInteger());
        BigDecimal result = new BigDecimal(this.bytes).divide(bigDecimal, bigDecimal.precision() + 1, RoundingMode.UNNECESSARY);
        return result.stripTrailingZeros();
    }

    @Override
    public long toBytes() {
        try {
            return this.bytes.longValueExact();
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Size " + String.valueOf(this) + " cannot be converted to number of bytes, out of long range.");
        }
    }

    @Override
    public String toString(Size.UnitKind unitKind) {
        Objects.requireNonNull(unitKind, "Unit kind must not be null");
        if (this.bytes.equals(BigInteger.ZERO)) {
            return "0 " + Size.Unit.BYTE.unitString(unitKind);
        }
        Size.Unit[] values = Size.Unit.values();
        for (int i = values.length - 1; i >= 0; --i) {
            Size.Unit value = values[i];
            if (value.isBinary() != unitKind.isBinary()) continue;
            BigDecimal bigDecimal = this.to(value);
            try {
                BigInteger bi = bigDecimal.toBigIntegerExact();
                return String.valueOf(bi) + " " + value.unitString(unitKind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(this.bytes) + " " + Size.Unit.BYTE.unitString(unitKind);
    }

    @Override
    public String toString(Size.Unit unit, Size.UnitKind unitKind) {
        Objects.requireNonNull(unit, "Unit must not be null");
        Objects.requireNonNull(unitKind, "Unit kind must not be null");
        if (unit.isBinary() != unitKind.isBinary()) {
            throw new IllegalArgumentException("Unit " + String.valueOf((Object)unit) + " does not match kind " + String.valueOf((Object)unitKind));
        }
        String unitString = unit.unitString(unitKind);
        BigDecimal amount = this.to(unit);
        return amount.toPlainString() + " " + unitString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Size)) {
            return false;
        }
        Size size = (Size)o;
        return Objects.equals(size.to(Size.Unit.BYTE), this.to(Size.Unit.BYTE));
    }

    public int hashCode() {
        return Objects.hash(this.to(Size.Unit.BYTE));
    }

    public String toString() {
        return this.toString(Size.UnitKind.DECIMAL_UPPER_CASE);
    }
}

