/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.encryption;

import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.KeyConfig;
import io.helidon.config.encryption.EncryptionUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;

public final class Main {
    private Main() {
        throw new IllegalStateException("Main class");
    }

    public static void main(String[] args) {
        EncryptionCliProcessor cli = new EncryptionCliProcessor();
        try {
            cli.parse(args);
            System.out.println(cli.encrypt());
        }
        catch (Exception e) {
            System.err.println("Failed to process input.");
            Main.help();
            throw e;
        }
    }

    private static void help() {
        System.out.println("To encrypt password using master password to be used in a property file:");
        System.out.println("java -jar secure-config-version.jar aes masterPassword secretToEncrypt");
        System.out.println();
        System.out.println("To encrypt password using public key to be used in a property file:");
        System.out.println("java -jar secure-config-version.jar rsa /path/to/pkcs12keystore keystorePassphrase publicCertAlias secretToEncrypt");
    }

    static class EncryptionCliProcessor {
        private Algorithm algorithm;
        private String secret;
        private PublicKey publicKey;
        private String masterPassword;

        EncryptionCliProcessor() {
        }

        void parse(String[] cliArgs) {
            if (cliArgs.length < 2) {
                Main.help();
                throw new ValidationException("Program must have two or more arguments");
            }
            String algorithm = cliArgs[0];
            if ("aes".equals(algorithm) || "gcm".equals(algorithm)) {
                this.parseAes(cliArgs);
            } else if ("rsa".equals(algorithm)) {
                this.parseRsa(cliArgs);
            } else {
                throw new ValidationException("First argument must be a valid algorithm (rsa or aes)");
            }
        }

        private void parseRsa(String[] cliArgs) {
            this.algorithm = Algorithm.rsa;
            if (cliArgs.length < 4) {
                throw new ValidationException("RSA encryption must have at least three parameters: keystorePath, keystorePassword and alias of certificate for public key");
            }
            this.secret = cliArgs.length == 4 ? "" : cliArgs[4];
            Path keyPath = Paths.get(cliArgs[1], new String[0]);
            if (!Files.exists(keyPath, new LinkOption[0]) || !Files.isRegularFile(keyPath, new LinkOption[0])) {
                throw new ValidationException("For rsa encryption the second parameter must be a keystore path, yet it is not accessible as a file: " + keyPath.toAbsolutePath());
            }
            String certAlias = cliArgs[3];
            KeyConfig kc = KeyConfig.keystoreBuilder().keystore(Resource.create((Path)keyPath)).keystorePassphrase(cliArgs[2].toCharArray()).certAlias(certAlias).build();
            this.publicKey = (PublicKey)kc.publicKey().orElseThrow(() -> new ValidationException("There is no public key available for cert alias: " + certAlias));
        }

        private void parseAes(String[] cliArgs) {
            String config = cliArgs[1];
            this.secret = cliArgs.length == 2 ? "" : cliArgs[2];
            this.algorithm = Algorithm.aes;
            this.masterPassword = config;
        }

        String encrypt() {
            switch (this.algorithm) {
                case aes: {
                    return this.aes();
                }
                case rsa: {
                    return this.rsa();
                }
            }
            return this.secret;
        }

        String rsa() {
            return "${RSA-P=" + EncryptionUtil.encryptRsa(this.publicKey, this.secret) + '}';
        }

        String aes() {
            return "${GCM=" + EncryptionUtil.encryptAes(this.masterPassword.toCharArray(), this.secret) + '}';
        }

        Algorithm getAlgorithm() {
            return this.algorithm;
        }

        String getMasterPassword() {
            return this.masterPassword;
        }

        PublicKey getPublicKey() {
            return this.publicKey;
        }

        String getSecret() {
            return this.secret;
        }
    }

    static class ValidationException
    extends RuntimeException {
        ValidationException(String message) {
            super(message);
        }
    }

    static enum Algorithm {
        aes,
        gcm,
        rsa;

    }
}

