/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.encryption;

import io.helidon.config.encryption.ConfigEncryptionException;
import io.helidon.config.encryption.EncryptionUtil;
import io.helidon.config.mp.spi.MpConfigFilter;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.config.Config;

public final class MpEncryptionFilter
implements MpConfigFilter {
    private static final String PREFIX_LEGACY_AES = "${AES=";
    private static final String PREFIX_LEGACY_RSA = "${RSA=";
    static final String PREFIX_GCM = "${GCM=";
    static final String PREFIX_RSA = "${RSA-P=";
    private static final System.Logger LOGGER = System.getLogger(MpEncryptionFilter.class.getName());
    private static final String PREFIX_ALIAS = "${ALIAS=";
    private static final String PREFIX_CLEAR = "${CLEAR=";
    private PrivateKey privateKey;
    private char[] masterPassword;
    private boolean requireEncryption;
    private MpConfigFilter clearFilter;
    private MpConfigFilter rsaFilter;
    private MpConfigFilter aesFilter;
    private MpConfigFilter aliasFilter;

    @Deprecated
    public MpEncryptionFilter() {
    }

    public void init(Config config) {
        this.requireEncryption = EncryptionUtil.getEnv("SECURE_CONFIG_REQUIRE_ENCRYPTION").map(Boolean::parseBoolean).or(() -> config.getOptionalValue("security.config.require-encryption", Boolean.class)).orElse(true);
        this.masterPassword = EncryptionUtil.resolveMasterPassword(this.requireEncryption, config).orElse(null);
        this.privateKey = EncryptionUtil.resolvePrivateKey(config).orElse(null);
        if (null != this.privateKey && !(this.privateKey instanceof RSAPrivateKey)) {
            throw new ConfigEncryptionException("Private key must be an RSA private key, but is: " + this.privateKey.getClass().getName());
        }
        MpConfigFilter noOp = (key, stringValue) -> stringValue;
        this.aesFilter = null == this.masterPassword ? noOp : (key, stringValue) -> this.decryptAes(this.masterPassword, stringValue);
        this.rsaFilter = null == this.privateKey ? noOp : (key, stringValue) -> this.decryptRsa(this.privateKey, stringValue);
        this.clearFilter = this::clearText;
        this.aliasFilter = (key, stringValue) -> this.aliased(stringValue, config);
    }

    public String apply(String propertyName, String value) {
        return this.maybeDecode(propertyName, value);
    }

    private static String removePlaceholder(String prefix, String value) {
        return value.substring(prefix.length(), value.length() - 1);
    }

    private String maybeDecode(String propertyName, String value) {
        HashSet<String> processedValues = new HashSet<String>();
        do {
            processedValues.add(value);
            if (!value.startsWith("${") && !value.endsWith("}")) {
                return value;
            }
            value = this.aliasFilter.apply(propertyName, value);
            value = this.clearFilter.apply(propertyName, value);
            value = this.rsaFilter.apply(propertyName, value);
        } while (!processedValues.contains(value = this.aesFilter.apply(propertyName, value)));
        return value;
    }

    private String clearText(String propertyName, String value) {
        if (value.startsWith(PREFIX_CLEAR)) {
            if (this.requireEncryption) {
                throw new ConfigEncryptionException("Key \"" + propertyName + "\" is a clear text password, yet encryption is required");
            }
            return MpEncryptionFilter.removePlaceholder(PREFIX_CLEAR, value);
        }
        return value;
    }

    private String aliased(String value, Config config) {
        if (value.startsWith(PREFIX_ALIAS)) {
            String alias = MpEncryptionFilter.removePlaceholder(PREFIX_ALIAS, value);
            return (String)config.getOptionalValue(alias, String.class).orElseThrow(() -> new NoSuchElementException("Aliased key not found. Value: " + value));
        }
        return value;
    }

    private String decryptRsa(PrivateKey privateKey, String value) {
        if (value.startsWith(PREFIX_LEGACY_RSA)) {
            LOGGER.log(System.Logger.Level.WARNING, () -> "You are using legacy RSA encryption. Please re-encrypt the value with RSA-P.");
            String b64Value = MpEncryptionFilter.removePlaceholder(PREFIX_LEGACY_RSA, value);
            try {
                return EncryptionUtil.decryptRsaLegacy(privateKey, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        if (value.startsWith(PREFIX_RSA)) {
            String b64Value = MpEncryptionFilter.removePlaceholder(PREFIX_RSA, value);
            try {
                return EncryptionUtil.decryptRsa(privateKey, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        return value;
    }

    private String decryptAes(char[] masterPassword, String value) {
        if (value.startsWith(PREFIX_LEGACY_AES)) {
            LOGGER.log(System.Logger.Level.WARNING, () -> "You are using legacy AES encryption. Please re-encrypt the value with GCM.");
            String b64Value = value.substring(PREFIX_LEGACY_AES.length(), value.length() - 1);
            try {
                return EncryptionUtil.decryptAesLegacy(masterPassword, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        if (value.startsWith(PREFIX_GCM)) {
            String b64Value = value.substring(PREFIX_GCM.length(), value.length() - 1);
            try {
                return EncryptionUtil.decryptAes(masterPassword, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        return value;
    }
}

