package io.helidon.config.etcd.internal.client.proto;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.16.1)",
    comments = "Source: rpc.proto")
public final class AuthGrpc {

  private AuthGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.Auth";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthEnableRequest,
      io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> getAuthEnableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AuthEnable",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthEnableRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthEnableResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthEnableRequest,
      io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> getAuthEnableMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthEnableRequest, io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> getAuthEnableMethod;
    if ((getAuthEnableMethod = AuthGrpc.getAuthEnableMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getAuthEnableMethod = AuthGrpc.getAuthEnableMethod) == null) {
          AuthGrpc.getAuthEnableMethod = getAuthEnableMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthEnableRequest, io.helidon.config.etcd.internal.client.proto.AuthEnableResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "AuthEnable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthEnableRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthEnableResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("AuthEnable"))
                  .build();
          }
        }
     }
     return getAuthEnableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthDisableRequest,
      io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> getAuthDisableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AuthDisable",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthDisableRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthDisableResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthDisableRequest,
      io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> getAuthDisableMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthDisableRequest, io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> getAuthDisableMethod;
    if ((getAuthDisableMethod = AuthGrpc.getAuthDisableMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getAuthDisableMethod = AuthGrpc.getAuthDisableMethod) == null) {
          AuthGrpc.getAuthDisableMethod = getAuthDisableMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthDisableRequest, io.helidon.config.etcd.internal.client.proto.AuthDisableResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "AuthDisable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthDisableRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthDisableResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("AuthDisable"))
                  .build();
          }
        }
     }
     return getAuthDisableMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthenticateRequest,
      io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> getAuthenticateMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Authenticate",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthenticateRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthenticateResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthenticateRequest,
      io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> getAuthenticateMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthenticateRequest, io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> getAuthenticateMethod;
    if ((getAuthenticateMethod = AuthGrpc.getAuthenticateMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getAuthenticateMethod = AuthGrpc.getAuthenticateMethod) == null) {
          AuthGrpc.getAuthenticateMethod = getAuthenticateMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthenticateRequest, io.helidon.config.etcd.internal.client.proto.AuthenticateResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "Authenticate"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthenticateRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthenticateResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("Authenticate"))
                  .build();
          }
        }
     }
     return getAuthenticateMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> getUserAddMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserAdd",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> getUserAddMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest, io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> getUserAddMethod;
    if ((getUserAddMethod = AuthGrpc.getUserAddMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserAddMethod = AuthGrpc.getUserAddMethod) == null) {
          AuthGrpc.getUserAddMethod = getUserAddMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest, io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserAdd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserAdd"))
                  .build();
          }
        }
     }
     return getUserAddMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> getUserGetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserGet",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> getUserGetMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest, io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> getUserGetMethod;
    if ((getUserGetMethod = AuthGrpc.getUserGetMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserGetMethod = AuthGrpc.getUserGetMethod) == null) {
          AuthGrpc.getUserGetMethod = getUserGetMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest, io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserGet"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserGet"))
                  .build();
          }
        }
     }
     return getUserGetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserListRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> getUserListMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserList",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserListRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserListResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserListRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> getUserListMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserListRequest, io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> getUserListMethod;
    if ((getUserListMethod = AuthGrpc.getUserListMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserListMethod = AuthGrpc.getUserListMethod) == null) {
          AuthGrpc.getUserListMethod = getUserListMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserListRequest, io.helidon.config.etcd.internal.client.proto.AuthUserListResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserList"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserListRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserListResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserList"))
                  .build();
          }
        }
     }
     return getUserListMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> getUserDeleteMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserDelete",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> getUserDeleteMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest, io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> getUserDeleteMethod;
    if ((getUserDeleteMethod = AuthGrpc.getUserDeleteMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserDeleteMethod = AuthGrpc.getUserDeleteMethod) == null) {
          AuthGrpc.getUserDeleteMethod = getUserDeleteMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest, io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserDelete"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserDelete"))
                  .build();
          }
        }
     }
     return getUserDeleteMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> getUserChangePasswordMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserChangePassword",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> getUserChangePasswordMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest, io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> getUserChangePasswordMethod;
    if ((getUserChangePasswordMethod = AuthGrpc.getUserChangePasswordMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserChangePasswordMethod = AuthGrpc.getUserChangePasswordMethod) == null) {
          AuthGrpc.getUserChangePasswordMethod = getUserChangePasswordMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest, io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserChangePassword"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserChangePassword"))
                  .build();
          }
        }
     }
     return getUserChangePasswordMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> getUserGrantRoleMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserGrantRole",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> getUserGrantRoleMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest, io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> getUserGrantRoleMethod;
    if ((getUserGrantRoleMethod = AuthGrpc.getUserGrantRoleMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserGrantRoleMethod = AuthGrpc.getUserGrantRoleMethod) == null) {
          AuthGrpc.getUserGrantRoleMethod = getUserGrantRoleMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest, io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserGrantRole"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserGrantRole"))
                  .build();
          }
        }
     }
     return getUserGrantRoleMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> getUserRevokeRoleMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UserRevokeRole",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest,
      io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> getUserRevokeRoleMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest, io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> getUserRevokeRoleMethod;
    if ((getUserRevokeRoleMethod = AuthGrpc.getUserRevokeRoleMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getUserRevokeRoleMethod = AuthGrpc.getUserRevokeRoleMethod) == null) {
          AuthGrpc.getUserRevokeRoleMethod = getUserRevokeRoleMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest, io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "UserRevokeRole"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserRevokeRole"))
                  .build();
          }
        }
     }
     return getUserRevokeRoleMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> getRoleAddMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleAdd",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> getRoleAddMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> getRoleAddMethod;
    if ((getRoleAddMethod = AuthGrpc.getRoleAddMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleAddMethod = AuthGrpc.getRoleAddMethod) == null) {
          AuthGrpc.getRoleAddMethod = getRoleAddMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleAdd"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleAdd"))
                  .build();
          }
        }
     }
     return getRoleAddMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> getRoleGetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleGet",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> getRoleGetMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> getRoleGetMethod;
    if ((getRoleGetMethod = AuthGrpc.getRoleGetMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleGetMethod = AuthGrpc.getRoleGetMethod) == null) {
          AuthGrpc.getRoleGetMethod = getRoleGetMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleGet"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleGet"))
                  .build();
          }
        }
     }
     return getRoleGetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> getRoleListMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleList",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> getRoleListMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> getRoleListMethod;
    if ((getRoleListMethod = AuthGrpc.getRoleListMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleListMethod = AuthGrpc.getRoleListMethod) == null) {
          AuthGrpc.getRoleListMethod = getRoleListMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleList"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleList"))
                  .build();
          }
        }
     }
     return getRoleListMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> getRoleDeleteMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleDelete",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> getRoleDeleteMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> getRoleDeleteMethod;
    if ((getRoleDeleteMethod = AuthGrpc.getRoleDeleteMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleDeleteMethod = AuthGrpc.getRoleDeleteMethod) == null) {
          AuthGrpc.getRoleDeleteMethod = getRoleDeleteMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleDelete"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleDelete"))
                  .build();
          }
        }
     }
     return getRoleDeleteMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> getRoleGrantPermissionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleGrantPermission",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> getRoleGrantPermissionMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> getRoleGrantPermissionMethod;
    if ((getRoleGrantPermissionMethod = AuthGrpc.getRoleGrantPermissionMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleGrantPermissionMethod = AuthGrpc.getRoleGrantPermissionMethod) == null) {
          AuthGrpc.getRoleGrantPermissionMethod = getRoleGrantPermissionMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleGrantPermission"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleGrantPermission"))
                  .build();
          }
        }
     }
     return getRoleGrantPermissionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> getRoleRevokePermissionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RoleRevokePermission",
      requestType = io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest,
      io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> getRoleRevokePermissionMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> getRoleRevokePermissionMethod;
    if ((getRoleRevokePermissionMethod = AuthGrpc.getRoleRevokePermissionMethod) == null) {
      synchronized (AuthGrpc.class) {
        if ((getRoleRevokePermissionMethod = AuthGrpc.getRoleRevokePermissionMethod) == null) {
          AuthGrpc.getRoleRevokePermissionMethod = getRoleRevokePermissionMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest, io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Auth", "RoleRevokePermission"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleRevokePermission"))
                  .build();
          }
        }
     }
     return getRoleRevokePermissionMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static AuthStub newStub(io.grpc.Channel channel) {
    return new AuthStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static AuthBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new AuthBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static AuthFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new AuthFutureStub(channel);
  }

  /**
   */
  public static abstract class AuthImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public void authEnable(io.helidon.config.etcd.internal.client.proto.AuthEnableRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAuthEnableMethod(), responseObserver);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public void authDisable(io.helidon.config.etcd.internal.client.proto.AuthDisableRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAuthDisableMethod(), responseObserver);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public void authenticate(io.helidon.config.etcd.internal.client.proto.AuthenticateRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAuthenticateMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public void userAdd(io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserAddMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public void userGet(io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserGetMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public void userList(io.helidon.config.etcd.internal.client.proto.AuthUserListRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserListMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public void userDelete(io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserDeleteMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public void userChangePassword(io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserChangePasswordMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public void userGrantRole(io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserGrantRoleMethod(), responseObserver);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public void userRevokeRole(io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUserRevokeRoleMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public void roleAdd(io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleAddMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public void roleGet(io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleGetMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public void roleList(io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleListMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public void roleDelete(io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleDeleteMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public void roleGrantPermission(io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleGrantPermissionMethod(), responseObserver);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public void roleRevokePermission(io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRoleRevokePermissionMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getAuthEnableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthEnableRequest,
                io.helidon.config.etcd.internal.client.proto.AuthEnableResponse>(
                  this, METHODID_AUTH_ENABLE)))
          .addMethod(
            getAuthDisableMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthDisableRequest,
                io.helidon.config.etcd.internal.client.proto.AuthDisableResponse>(
                  this, METHODID_AUTH_DISABLE)))
          .addMethod(
            getAuthenticateMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthenticateRequest,
                io.helidon.config.etcd.internal.client.proto.AuthenticateResponse>(
                  this, METHODID_AUTHENTICATE)))
          .addMethod(
            getUserAddMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse>(
                  this, METHODID_USER_ADD)))
          .addMethod(
            getUserGetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse>(
                  this, METHODID_USER_GET)))
          .addMethod(
            getUserListMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserListRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserListResponse>(
                  this, METHODID_USER_LIST)))
          .addMethod(
            getUserDeleteMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse>(
                  this, METHODID_USER_DELETE)))
          .addMethod(
            getUserChangePasswordMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse>(
                  this, METHODID_USER_CHANGE_PASSWORD)))
          .addMethod(
            getUserGrantRoleMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse>(
                  this, METHODID_USER_GRANT_ROLE)))
          .addMethod(
            getUserRevokeRoleMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest,
                io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse>(
                  this, METHODID_USER_REVOKE_ROLE)))
          .addMethod(
            getRoleAddMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse>(
                  this, METHODID_ROLE_ADD)))
          .addMethod(
            getRoleGetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse>(
                  this, METHODID_ROLE_GET)))
          .addMethod(
            getRoleListMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse>(
                  this, METHODID_ROLE_LIST)))
          .addMethod(
            getRoleDeleteMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse>(
                  this, METHODID_ROLE_DELETE)))
          .addMethod(
            getRoleGrantPermissionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse>(
                  this, METHODID_ROLE_GRANT_PERMISSION)))
          .addMethod(
            getRoleRevokePermissionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest,
                io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse>(
                  this, METHODID_ROLE_REVOKE_PERMISSION)))
          .build();
    }
  }

  /**
   */
  public static final class AuthStub extends io.grpc.stub.AbstractStub<AuthStub> {
    private AuthStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public void authEnable(io.helidon.config.etcd.internal.client.proto.AuthEnableRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAuthEnableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public void authDisable(io.helidon.config.etcd.internal.client.proto.AuthDisableRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAuthDisableMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public void authenticate(io.helidon.config.etcd.internal.client.proto.AuthenticateRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAuthenticateMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public void userAdd(io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserAddMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public void userGet(io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserGetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public void userList(io.helidon.config.etcd.internal.client.proto.AuthUserListRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserListMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public void userDelete(io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserDeleteMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public void userChangePassword(io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserChangePasswordMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public void userGrantRole(io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserGrantRoleMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public void userRevokeRole(io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUserRevokeRoleMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public void roleAdd(io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleAddMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public void roleGet(io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleGetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public void roleList(io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleListMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public void roleDelete(io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleDeleteMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public void roleGrantPermission(io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleGrantPermissionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public void roleRevokePermission(io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRoleRevokePermissionMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class AuthBlockingStub extends io.grpc.stub.AbstractStub<AuthBlockingStub> {
    private AuthBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthEnableResponse authEnable(io.helidon.config.etcd.internal.client.proto.AuthEnableRequest request) {
      return blockingUnaryCall(
          getChannel(), getAuthEnableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthDisableResponse authDisable(io.helidon.config.etcd.internal.client.proto.AuthDisableRequest request) {
      return blockingUnaryCall(
          getChannel(), getAuthDisableMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthenticateResponse authenticate(io.helidon.config.etcd.internal.client.proto.AuthenticateRequest request) {
      return blockingUnaryCall(
          getChannel(), getAuthenticateMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse userAdd(io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserAddMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse userGet(io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserGetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserListResponse userList(io.helidon.config.etcd.internal.client.proto.AuthUserListRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserListMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse userDelete(io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserDeleteMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse userChangePassword(io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserChangePasswordMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse userGrantRole(io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserGrantRoleMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse userRevokeRole(io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest request) {
      return blockingUnaryCall(
          getChannel(), getUserRevokeRoleMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse roleAdd(io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleAddMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse roleGet(io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleGetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse roleList(io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleListMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse roleDelete(io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleDeleteMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse roleGrantPermission(io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleGrantPermissionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse roleRevokePermission(io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest request) {
      return blockingUnaryCall(
          getChannel(), getRoleRevokePermissionMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class AuthFutureStub extends io.grpc.stub.AbstractStub<AuthFutureStub> {
    private AuthFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthEnableResponse> authEnable(
        io.helidon.config.etcd.internal.client.proto.AuthEnableRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAuthEnableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthDisableResponse> authDisable(
        io.helidon.config.etcd.internal.client.proto.AuthDisableRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAuthDisableMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthenticateResponse> authenticate(
        io.helidon.config.etcd.internal.client.proto.AuthenticateRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAuthenticateMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse> userAdd(
        io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserAddMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse> userGet(
        io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserGetMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserListResponse> userList(
        io.helidon.config.etcd.internal.client.proto.AuthUserListRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserListMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse> userDelete(
        io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserDeleteMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse> userChangePassword(
        io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserChangePasswordMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse> userGrantRole(
        io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserGrantRoleMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse> userRevokeRole(
        io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUserRevokeRoleMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse> roleAdd(
        io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleAddMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse> roleGet(
        io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleGetMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse> roleList(
        io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleListMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse> roleDelete(
        io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleDeleteMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse> roleGrantPermission(
        io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleGrantPermissionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse> roleRevokePermission(
        io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRoleRevokePermissionMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_AUTH_ENABLE = 0;
  private static final int METHODID_AUTH_DISABLE = 1;
  private static final int METHODID_AUTHENTICATE = 2;
  private static final int METHODID_USER_ADD = 3;
  private static final int METHODID_USER_GET = 4;
  private static final int METHODID_USER_LIST = 5;
  private static final int METHODID_USER_DELETE = 6;
  private static final int METHODID_USER_CHANGE_PASSWORD = 7;
  private static final int METHODID_USER_GRANT_ROLE = 8;
  private static final int METHODID_USER_REVOKE_ROLE = 9;
  private static final int METHODID_ROLE_ADD = 10;
  private static final int METHODID_ROLE_GET = 11;
  private static final int METHODID_ROLE_LIST = 12;
  private static final int METHODID_ROLE_DELETE = 13;
  private static final int METHODID_ROLE_GRANT_PERMISSION = 14;
  private static final int METHODID_ROLE_REVOKE_PERMISSION = 15;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AuthImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(AuthImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_AUTH_ENABLE:
          serviceImpl.authEnable((io.helidon.config.etcd.internal.client.proto.AuthEnableRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthEnableResponse>) responseObserver);
          break;
        case METHODID_AUTH_DISABLE:
          serviceImpl.authDisable((io.helidon.config.etcd.internal.client.proto.AuthDisableRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthDisableResponse>) responseObserver);
          break;
        case METHODID_AUTHENTICATE:
          serviceImpl.authenticate((io.helidon.config.etcd.internal.client.proto.AuthenticateRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthenticateResponse>) responseObserver);
          break;
        case METHODID_USER_ADD:
          serviceImpl.userAdd((io.helidon.config.etcd.internal.client.proto.AuthUserAddRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserAddResponse>) responseObserver);
          break;
        case METHODID_USER_GET:
          serviceImpl.userGet((io.helidon.config.etcd.internal.client.proto.AuthUserGetRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGetResponse>) responseObserver);
          break;
        case METHODID_USER_LIST:
          serviceImpl.userList((io.helidon.config.etcd.internal.client.proto.AuthUserListRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserListResponse>) responseObserver);
          break;
        case METHODID_USER_DELETE:
          serviceImpl.userDelete((io.helidon.config.etcd.internal.client.proto.AuthUserDeleteRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserDeleteResponse>) responseObserver);
          break;
        case METHODID_USER_CHANGE_PASSWORD:
          serviceImpl.userChangePassword((io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserChangePasswordResponse>) responseObserver);
          break;
        case METHODID_USER_GRANT_ROLE:
          serviceImpl.userGrantRole((io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserGrantRoleResponse>) responseObserver);
          break;
        case METHODID_USER_REVOKE_ROLE:
          serviceImpl.userRevokeRole((io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthUserRevokeRoleResponse>) responseObserver);
          break;
        case METHODID_ROLE_ADD:
          serviceImpl.roleAdd((io.helidon.config.etcd.internal.client.proto.AuthRoleAddRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleAddResponse>) responseObserver);
          break;
        case METHODID_ROLE_GET:
          serviceImpl.roleGet((io.helidon.config.etcd.internal.client.proto.AuthRoleGetRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGetResponse>) responseObserver);
          break;
        case METHODID_ROLE_LIST:
          serviceImpl.roleList((io.helidon.config.etcd.internal.client.proto.AuthRoleListRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleListResponse>) responseObserver);
          break;
        case METHODID_ROLE_DELETE:
          serviceImpl.roleDelete((io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleDeleteResponse>) responseObserver);
          break;
        case METHODID_ROLE_GRANT_PERMISSION:
          serviceImpl.roleGrantPermission((io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleGrantPermissionResponse>) responseObserver);
          break;
        case METHODID_ROLE_REVOKE_PERMISSION:
          serviceImpl.roleRevokePermission((io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AuthRoleRevokePermissionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class AuthBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    AuthBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.helidon.config.etcd.internal.client.proto.EtcdProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Auth");
    }
  }

  private static final class AuthFileDescriptorSupplier
      extends AuthBaseDescriptorSupplier {
    AuthFileDescriptorSupplier() {}
  }

  private static final class AuthMethodDescriptorSupplier
      extends AuthBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    AuthMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (AuthGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new AuthFileDescriptorSupplier())
              .addMethod(getAuthEnableMethod())
              .addMethod(getAuthDisableMethod())
              .addMethod(getAuthenticateMethod())
              .addMethod(getUserAddMethod())
              .addMethod(getUserGetMethod())
              .addMethod(getUserListMethod())
              .addMethod(getUserDeleteMethod())
              .addMethod(getUserChangePasswordMethod())
              .addMethod(getUserGrantRoleMethod())
              .addMethod(getUserRevokeRoleMethod())
              .addMethod(getRoleAddMethod())
              .addMethod(getRoleGetMethod())
              .addMethod(getRoleListMethod())
              .addMethod(getRoleDeleteMethod())
              .addMethod(getRoleGrantPermissionMethod())
              .addMethod(getRoleRevokePermissionMethod())
              .build();
        }
      }
    }
    return result;
  }
}
