package io.helidon.config.etcd.internal.client.proto;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.16.1)",
    comments = "Source: rpc.proto")
public final class MaintenanceGrpc {

  private MaintenanceGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.Maintenance";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AlarmRequest,
      io.helidon.config.etcd.internal.client.proto.AlarmResponse> getAlarmMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Alarm",
      requestType = io.helidon.config.etcd.internal.client.proto.AlarmRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.AlarmResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AlarmRequest,
      io.helidon.config.etcd.internal.client.proto.AlarmResponse> getAlarmMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.AlarmRequest, io.helidon.config.etcd.internal.client.proto.AlarmResponse> getAlarmMethod;
    if ((getAlarmMethod = MaintenanceGrpc.getAlarmMethod) == null) {
      synchronized (MaintenanceGrpc.class) {
        if ((getAlarmMethod = MaintenanceGrpc.getAlarmMethod) == null) {
          MaintenanceGrpc.getAlarmMethod = getAlarmMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.AlarmRequest, io.helidon.config.etcd.internal.client.proto.AlarmResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Maintenance", "Alarm"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AlarmRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.AlarmResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MaintenanceMethodDescriptorSupplier("Alarm"))
                  .build();
          }
        }
     }
     return getAlarmMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.StatusRequest,
      io.helidon.config.etcd.internal.client.proto.StatusResponse> getStatusMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Status",
      requestType = io.helidon.config.etcd.internal.client.proto.StatusRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.StatusResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.StatusRequest,
      io.helidon.config.etcd.internal.client.proto.StatusResponse> getStatusMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.StatusRequest, io.helidon.config.etcd.internal.client.proto.StatusResponse> getStatusMethod;
    if ((getStatusMethod = MaintenanceGrpc.getStatusMethod) == null) {
      synchronized (MaintenanceGrpc.class) {
        if ((getStatusMethod = MaintenanceGrpc.getStatusMethod) == null) {
          MaintenanceGrpc.getStatusMethod = getStatusMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.StatusRequest, io.helidon.config.etcd.internal.client.proto.StatusResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Maintenance", "Status"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.StatusRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.StatusResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MaintenanceMethodDescriptorSupplier("Status"))
                  .build();
          }
        }
     }
     return getStatusMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.DefragmentRequest,
      io.helidon.config.etcd.internal.client.proto.DefragmentResponse> getDefragmentMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Defragment",
      requestType = io.helidon.config.etcd.internal.client.proto.DefragmentRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.DefragmentResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.DefragmentRequest,
      io.helidon.config.etcd.internal.client.proto.DefragmentResponse> getDefragmentMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.DefragmentRequest, io.helidon.config.etcd.internal.client.proto.DefragmentResponse> getDefragmentMethod;
    if ((getDefragmentMethod = MaintenanceGrpc.getDefragmentMethod) == null) {
      synchronized (MaintenanceGrpc.class) {
        if ((getDefragmentMethod = MaintenanceGrpc.getDefragmentMethod) == null) {
          MaintenanceGrpc.getDefragmentMethod = getDefragmentMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.DefragmentRequest, io.helidon.config.etcd.internal.client.proto.DefragmentResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Maintenance", "Defragment"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.DefragmentRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.DefragmentResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MaintenanceMethodDescriptorSupplier("Defragment"))
                  .build();
          }
        }
     }
     return getDefragmentMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.HashRequest,
      io.helidon.config.etcd.internal.client.proto.HashResponse> getHashMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Hash",
      requestType = io.helidon.config.etcd.internal.client.proto.HashRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.HashResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.HashRequest,
      io.helidon.config.etcd.internal.client.proto.HashResponse> getHashMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.HashRequest, io.helidon.config.etcd.internal.client.proto.HashResponse> getHashMethod;
    if ((getHashMethod = MaintenanceGrpc.getHashMethod) == null) {
      synchronized (MaintenanceGrpc.class) {
        if ((getHashMethod = MaintenanceGrpc.getHashMethod) == null) {
          MaintenanceGrpc.getHashMethod = getHashMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.HashRequest, io.helidon.config.etcd.internal.client.proto.HashResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Maintenance", "Hash"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.HashRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.HashResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MaintenanceMethodDescriptorSupplier("Hash"))
                  .build();
          }
        }
     }
     return getHashMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.SnapshotRequest,
      io.helidon.config.etcd.internal.client.proto.SnapshotResponse> getSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Snapshot",
      requestType = io.helidon.config.etcd.internal.client.proto.SnapshotRequest.class,
      responseType = io.helidon.config.etcd.internal.client.proto.SnapshotResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.SnapshotRequest,
      io.helidon.config.etcd.internal.client.proto.SnapshotResponse> getSnapshotMethod() {
    io.grpc.MethodDescriptor<io.helidon.config.etcd.internal.client.proto.SnapshotRequest, io.helidon.config.etcd.internal.client.proto.SnapshotResponse> getSnapshotMethod;
    if ((getSnapshotMethod = MaintenanceGrpc.getSnapshotMethod) == null) {
      synchronized (MaintenanceGrpc.class) {
        if ((getSnapshotMethod = MaintenanceGrpc.getSnapshotMethod) == null) {
          MaintenanceGrpc.getSnapshotMethod = getSnapshotMethod = 
              io.grpc.MethodDescriptor.<io.helidon.config.etcd.internal.client.proto.SnapshotRequest, io.helidon.config.etcd.internal.client.proto.SnapshotResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Maintenance", "Snapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.SnapshotRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.helidon.config.etcd.internal.client.proto.SnapshotResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MaintenanceMethodDescriptorSupplier("Snapshot"))
                  .build();
          }
        }
     }
     return getSnapshotMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MaintenanceStub newStub(io.grpc.Channel channel) {
    return new MaintenanceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MaintenanceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new MaintenanceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MaintenanceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new MaintenanceFutureStub(channel);
  }

  /**
   */
  public static abstract class MaintenanceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Alarm activates, deactivates, and queries alarms regarding cluster health.
     * </pre>
     */
    public void alarm(io.helidon.config.etcd.internal.client.proto.AlarmRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AlarmResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAlarmMethod(), responseObserver);
    }

    /**
     * <pre>
     * Status gets the status of the member.
     * </pre>
     */
    public void status(io.helidon.config.etcd.internal.client.proto.StatusRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.StatusResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getStatusMethod(), responseObserver);
    }

    /**
     * <pre>
     * Defragment defragments a member's backend database to recover storage space.
     * </pre>
     */
    public void defragment(io.helidon.config.etcd.internal.client.proto.DefragmentRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.DefragmentResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDefragmentMethod(), responseObserver);
    }

    /**
     * <pre>
     * Hash returns the hash of the local KV state for consistency checking purpose.
     * This is designed for testing; do not use this in production when there
     * are ongoing transactions.
     * </pre>
     */
    public void hash(io.helidon.config.etcd.internal.client.proto.HashRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.HashResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getHashMethod(), responseObserver);
    }

    /**
     * <pre>
     * Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
     * </pre>
     */
    public void snapshot(io.helidon.config.etcd.internal.client.proto.SnapshotRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.SnapshotResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSnapshotMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getAlarmMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.AlarmRequest,
                io.helidon.config.etcd.internal.client.proto.AlarmResponse>(
                  this, METHODID_ALARM)))
          .addMethod(
            getStatusMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.StatusRequest,
                io.helidon.config.etcd.internal.client.proto.StatusResponse>(
                  this, METHODID_STATUS)))
          .addMethod(
            getDefragmentMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.DefragmentRequest,
                io.helidon.config.etcd.internal.client.proto.DefragmentResponse>(
                  this, METHODID_DEFRAGMENT)))
          .addMethod(
            getHashMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.HashRequest,
                io.helidon.config.etcd.internal.client.proto.HashResponse>(
                  this, METHODID_HASH)))
          .addMethod(
            getSnapshotMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.helidon.config.etcd.internal.client.proto.SnapshotRequest,
                io.helidon.config.etcd.internal.client.proto.SnapshotResponse>(
                  this, METHODID_SNAPSHOT)))
          .build();
    }
  }

  /**
   */
  public static final class MaintenanceStub extends io.grpc.stub.AbstractStub<MaintenanceStub> {
    private MaintenanceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MaintenanceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MaintenanceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MaintenanceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Alarm activates, deactivates, and queries alarms regarding cluster health.
     * </pre>
     */
    public void alarm(io.helidon.config.etcd.internal.client.proto.AlarmRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AlarmResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAlarmMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Status gets the status of the member.
     * </pre>
     */
    public void status(io.helidon.config.etcd.internal.client.proto.StatusRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.StatusResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStatusMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Defragment defragments a member's backend database to recover storage space.
     * </pre>
     */
    public void defragment(io.helidon.config.etcd.internal.client.proto.DefragmentRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.DefragmentResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDefragmentMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Hash returns the hash of the local KV state for consistency checking purpose.
     * This is designed for testing; do not use this in production when there
     * are ongoing transactions.
     * </pre>
     */
    public void hash(io.helidon.config.etcd.internal.client.proto.HashRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.HashResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getHashMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
     * </pre>
     */
    public void snapshot(io.helidon.config.etcd.internal.client.proto.SnapshotRequest request,
        io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.SnapshotResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getSnapshotMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class MaintenanceBlockingStub extends io.grpc.stub.AbstractStub<MaintenanceBlockingStub> {
    private MaintenanceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MaintenanceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MaintenanceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MaintenanceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Alarm activates, deactivates, and queries alarms regarding cluster health.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.AlarmResponse alarm(io.helidon.config.etcd.internal.client.proto.AlarmRequest request) {
      return blockingUnaryCall(
          getChannel(), getAlarmMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Status gets the status of the member.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.StatusResponse status(io.helidon.config.etcd.internal.client.proto.StatusRequest request) {
      return blockingUnaryCall(
          getChannel(), getStatusMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Defragment defragments a member's backend database to recover storage space.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.DefragmentResponse defragment(io.helidon.config.etcd.internal.client.proto.DefragmentRequest request) {
      return blockingUnaryCall(
          getChannel(), getDefragmentMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Hash returns the hash of the local KV state for consistency checking purpose.
     * This is designed for testing; do not use this in production when there
     * are ongoing transactions.
     * </pre>
     */
    public io.helidon.config.etcd.internal.client.proto.HashResponse hash(io.helidon.config.etcd.internal.client.proto.HashRequest request) {
      return blockingUnaryCall(
          getChannel(), getHashMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
     * </pre>
     */
    public java.util.Iterator<io.helidon.config.etcd.internal.client.proto.SnapshotResponse> snapshot(
        io.helidon.config.etcd.internal.client.proto.SnapshotRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getSnapshotMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class MaintenanceFutureStub extends io.grpc.stub.AbstractStub<MaintenanceFutureStub> {
    private MaintenanceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private MaintenanceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MaintenanceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new MaintenanceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Alarm activates, deactivates, and queries alarms regarding cluster health.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.AlarmResponse> alarm(
        io.helidon.config.etcd.internal.client.proto.AlarmRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAlarmMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Status gets the status of the member.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.StatusResponse> status(
        io.helidon.config.etcd.internal.client.proto.StatusRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getStatusMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Defragment defragments a member's backend database to recover storage space.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.DefragmentResponse> defragment(
        io.helidon.config.etcd.internal.client.proto.DefragmentRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDefragmentMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Hash returns the hash of the local KV state for consistency checking purpose.
     * This is designed for testing; do not use this in production when there
     * are ongoing transactions.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.helidon.config.etcd.internal.client.proto.HashResponse> hash(
        io.helidon.config.etcd.internal.client.proto.HashRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getHashMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ALARM = 0;
  private static final int METHODID_STATUS = 1;
  private static final int METHODID_DEFRAGMENT = 2;
  private static final int METHODID_HASH = 3;
  private static final int METHODID_SNAPSHOT = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MaintenanceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MaintenanceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ALARM:
          serviceImpl.alarm((io.helidon.config.etcd.internal.client.proto.AlarmRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.AlarmResponse>) responseObserver);
          break;
        case METHODID_STATUS:
          serviceImpl.status((io.helidon.config.etcd.internal.client.proto.StatusRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.StatusResponse>) responseObserver);
          break;
        case METHODID_DEFRAGMENT:
          serviceImpl.defragment((io.helidon.config.etcd.internal.client.proto.DefragmentRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.DefragmentResponse>) responseObserver);
          break;
        case METHODID_HASH:
          serviceImpl.hash((io.helidon.config.etcd.internal.client.proto.HashRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.HashResponse>) responseObserver);
          break;
        case METHODID_SNAPSHOT:
          serviceImpl.snapshot((io.helidon.config.etcd.internal.client.proto.SnapshotRequest) request,
              (io.grpc.stub.StreamObserver<io.helidon.config.etcd.internal.client.proto.SnapshotResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MaintenanceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MaintenanceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.helidon.config.etcd.internal.client.proto.EtcdProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Maintenance");
    }
  }

  private static final class MaintenanceFileDescriptorSupplier
      extends MaintenanceBaseDescriptorSupplier {
    MaintenanceFileDescriptorSupplier() {}
  }

  private static final class MaintenanceMethodDescriptorSupplier
      extends MaintenanceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MaintenanceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MaintenanceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MaintenanceFileDescriptorSupplier())
              .addMethod(getAlarmMethod())
              .addMethod(getStatusMethod())
              .addMethod(getDefragmentMethod())
              .addMethod(getHashMethod())
              .addMethod(getSnapshotMethod())
              .build();
        }
      }
    }
    return result;
  }
}
