/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.etcd;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.etcd.EtcdConfigSourceBuilder;
import io.helidon.config.etcd.internal.client.EtcdClient;
import io.helidon.config.etcd.internal.client.EtcdClientException;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigParser;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EtcdConfigSource
extends AbstractParsableConfigSource<Long> {
    private static final Logger LOGGER = Logger.getLogger(EtcdConfigSource.class.getName());
    private final EtcdConfigSourceBuilder.EtcdEndpoint endpoint;
    private final EtcdClient client;

    EtcdConfigSource(EtcdConfigSourceBuilder builder) {
        super((AbstractParsableConfigSource.Builder)builder);
        this.endpoint = builder.target();
        this.client = this.endpoint.api().clientFactory().createClient(this.endpoint.uri());
    }

    protected String mediaType() {
        return OptionalHelper.from(Optional.ofNullable(super.mediaType())).or(this::probeContentType).asOptional().orElse(null);
    }

    private Optional<String> probeContentType() {
        return Optional.ofNullable(ConfigHelper.detectContentType((Path)Paths.get(this.endpoint.key(), new String[0])));
    }

    protected String uid() {
        return this.endpoint.uri() + "#" + this.endpoint.key();
    }

    protected Optional<Long> dataStamp() {
        try {
            return Optional.of(this.etcdClient().revision(this.endpoint.key()));
        }
        catch (EtcdClientException e) {
            return Optional.empty();
        }
    }

    protected ConfigParser.Content<Long> content() throws ConfigException {
        String content = null;
        try {
            content = this.etcdClient().get(this.endpoint.key());
        }
        catch (EtcdClientException e) {
            LOGGER.log(Level.FINEST, "Get operation threw an exception.", e);
        }
        if (content == null) {
            throw new ConfigException(String.format("Key '%s' does not contain any value", this.endpoint.key()));
        }
        return ConfigParser.Content.create((Readable)new StringReader(content), (String)this.mediaType(), this.dataStamp());
    }

    EtcdConfigSourceBuilder.EtcdEndpoint etcdEndpoint() {
        return this.endpoint;
    }

    EtcdClient etcdClient() {
        return this.client;
    }

    public static EtcdConfigSource create(Config config) {
        return EtcdConfigSourceBuilder.create(config).build();
    }
}

