/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.etcd;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.etcd.EtcdConfigSource;
import io.helidon.config.etcd.internal.client.EtcdClientFactory;
import io.helidon.config.etcd.internal.client.v2.EtcdV2ClientFactory;
import io.helidon.config.etcd.internal.client.v3.EtcdV3ClientFactory;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.PollingStrategy;
import java.net.URI;
import java.util.Objects;

public final class EtcdConfigSourceBuilder
extends AbstractParsableConfigSource.Builder<EtcdConfigSourceBuilder, EtcdEndpoint> {
    private static final String URI_KEY = "uri";
    private static final String KEY_KEY = "key";
    private static final String API_KEY = "api";
    private final EtcdEndpoint etcdEndpoint;

    private EtcdConfigSourceBuilder(URI uri, String key, EtcdApi api) {
        super(EtcdEndpoint.class);
        Objects.requireNonNull(uri, "uri cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(api, "api cannot be null");
        this.etcdEndpoint = new EtcdEndpoint(uri, key, api);
    }

    public static EtcdConfigSourceBuilder create(URI uri, String key, EtcdApi api) {
        return new EtcdConfigSourceBuilder(uri, key, api);
    }

    public static EtcdConfigSourceBuilder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return EtcdConfigSourceBuilder.create((URI)metaConfig.get(URI_KEY).as(URI.class).get(), (String)metaConfig.get(KEY_KEY).asString().get(), (EtcdApi)((Object)metaConfig.get(API_KEY).asString().as(EtcdApi::valueOf).get())).init(metaConfig);
    }

    protected EtcdConfigSourceBuilder init(Config metaConfig) {
        return (EtcdConfigSourceBuilder)super.init(metaConfig);
    }

    protected EtcdEndpoint target() {
        return this.etcdEndpoint;
    }

    PollingStrategy pollingStrategyInternal() {
        return super.pollingStrategy();
    }

    public EtcdConfigSource build() {
        return new EtcdConfigSource(this);
    }

    public static class EtcdEndpoint {
        private final URI uri;
        private final String key;
        private final EtcdApi api;

        public EtcdEndpoint(URI uri, String key, EtcdApi api) {
            this.uri = uri;
            this.key = key;
            this.api = api;
        }

        public URI uri() {
            return this.uri;
        }

        public String key() {
            return this.key;
        }

        public EtcdApi api() {
            return this.api;
        }
    }

    public static enum EtcdApi {
        v2(new EtcdV2ClientFactory()),
        v3(new EtcdV3ClientFactory());

        private final EtcdClientFactory clientFactory;

        private EtcdApi(EtcdClientFactory clientFactory) {
            this.clientFactory = clientFactory;
        }

        public EtcdClientFactory clientFactory() {
            return this.clientFactory;
        }
    }
}

