/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.hocon.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.io.Reader;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;

@Priority(value=200)
public class HoconConfigParser
implements ConfigParser {
    public static final String MEDIA_TYPE_APPLICATION_HOCON = "application/hocon";
    public static final String MEDIA_TYPE_APPLICATION_JSON = "application/json";
    public static final int PRIORITY = 200;
    private static final Set<String> SUPPORTED_MEDIA_TYPES = CollectionsHelper.setOf((Object[])new String[]{"application/hocon", "application/json"});
    private final boolean resolvingEnabled;
    private final ConfigResolveOptions resolveOptions;

    public HoconConfigParser(boolean resolvingEnabled, ConfigResolveOptions resolveOptions) {
        if (resolvingEnabled) {
            Objects.requireNonNull(resolveOptions, "resolveOptions parameter is mandatory");
        }
        this.resolvingEnabled = resolvingEnabled;
        this.resolveOptions = resolveOptions;
    }

    public HoconConfigParser() {
        this(true, ConfigResolveOptions.defaults());
    }

    public Set<String> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> ConfigNode.ObjectNode parse(ConfigParser.Content<S> content) {
        try (AutoCloseable readable = (AutoCloseable)((Object)content.asReadable());){
            Config typesafeConfig = ConfigFactory.parseReader((Reader)ConfigHelper.createReader((Readable)((Readable)((Object)readable))));
            if (this.resolvingEnabled) {
                typesafeConfig = typesafeConfig.resolve(this.resolveOptions);
            }
            ConfigNode.ObjectNode objectNode = HoconConfigParser.fromConfig(typesafeConfig.root());
            return objectNode;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static ConfigNode.ObjectNode fromConfig(ConfigObject config) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        config.entrySet().forEach(entry -> {
            String key = Config.Key.escapeName((String)((String)entry.getKey()));
            ConfigValue value = (ConfigValue)entry.getValue();
            if (value instanceof ConfigList) {
                builder.addList(key, HoconConfigParser.fromList((ConfigList)value));
            } else if (value instanceof ConfigObject) {
                builder.addObject(key, HoconConfigParser.fromConfig((ConfigObject)value));
            } else {
                builder.addValue(key, value.unwrapped().toString());
            }
        });
        return builder.build();
    }

    private static ConfigNode.ListNode fromList(ConfigList list) {
        ConfigNode.ListNode.Builder builder = ConfigNode.ListNode.builder();
        list.forEach(value -> {
            if (value instanceof ConfigList) {
                builder.addList(HoconConfigParser.fromList((ConfigList)value));
            } else if (value instanceof ConfigObject) {
                builder.addObject(HoconConfigParser.fromConfig((ConfigObject)value));
            } else {
                builder.addValue(value.unwrapped().toString());
            }
        });
        return (ConfigNode.ListNode)builder.build();
    }
}

