/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.hocon;

import com.typesafe.config.ConfigResolveOptions;
import io.helidon.common.Builder;
import io.helidon.config.hocon.internal.HoconConfigParser;
import io.helidon.config.spi.ConfigParser;
import java.util.Objects;

public final class HoconConfigParserBuilder
implements Builder<ConfigParser> {
    private boolean resolvingEnabled = true;
    private ConfigResolveOptions resolveOptions = ConfigResolveOptions.defaults();

    private HoconConfigParserBuilder() {
    }

    public static ConfigParser buildDefault() {
        return HoconConfigParserBuilder.create().build();
    }

    public static HoconConfigParserBuilder create() {
        return new HoconConfigParserBuilder();
    }

    public HoconConfigParserBuilder disableResolving() {
        this.resolvingEnabled = false;
        return this;
    }

    public HoconConfigParserBuilder resolveOptions(ConfigResolveOptions resolveOptions) {
        this.resolveOptions = Objects.requireNonNull(resolveOptions);
        return this;
    }

    public ConfigParser build() {
        return new HoconConfigParser(this.resolvingEnabled, this.resolveOptions);
    }
}

