/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.common.serviceloader.Priorities;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappers;
import io.helidon.config.mp.MpConfigImpl;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.config.mp.spi.MpConfigFilter;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class MpConfigBuilder
implements ConfigBuilder {
    private boolean useDefaultSources = false;
    private boolean useDiscoveredSources = false;
    private boolean useDiscoveredConverters = false;
    private final List<OrdinalSource> sources = new LinkedList<OrdinalSource>();
    private final List<OrdinalConverter> converters = new LinkedList<OrdinalConverter>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    MpConfigBuilder() {
    }

    public ConfigBuilder addDefaultSources() {
        this.useDefaultSources = true;
        return this;
    }

    public ConfigBuilder addDiscoveredSources() {
        this.useDiscoveredSources = true;
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        this.useDiscoveredConverters = true;
        return this;
    }

    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... sources) {
        for (ConfigSource source : sources) {
            this.sources.add(new OrdinalSource(source));
        }
        return this;
    }

    public <T> ConfigBuilder withConverter(Class<T> aClass, int ordinal, Converter<T> converter) {
        this.converters.add(new OrdinalConverter(converter, aClass, ordinal));
        return this;
    }

    public ConfigBuilder withConverters(Converter<?> ... converters) {
        for (Converter<?> converter : converters) {
            this.converters.add(new OrdinalConverter(converter));
        }
        return this;
    }

    public org.eclipse.microprofile.config.Config build() {
        if (this.useDefaultSources) {
            this.sources.add(new OrdinalSource(MpConfigSources.systemProperties(), 400));
            this.sources.add(new OrdinalSource(MpConfigSources.environmentVariables(), 300));
            MpConfigSources.classPath(this.classLoader, "META-INF/microprofile-config.properties").stream().map(x$0 -> new OrdinalSource((ConfigSource)x$0)).forEach(this.sources::add);
        }
        this.addBuiltIn(this.converters, Boolean.class, ConfigMappers::toBoolean);
        this.addBuiltIn(this.converters, Boolean.TYPE, ConfigMappers::toBoolean);
        this.addBuiltIn(this.converters, Byte.class, Byte::parseByte);
        this.addBuiltIn(this.converters, Byte.TYPE, Byte::parseByte);
        this.addBuiltIn(this.converters, Short.class, Short::parseShort);
        this.addBuiltIn(this.converters, Short.TYPE, Short::parseShort);
        this.addBuiltIn(this.converters, Integer.class, Integer::parseInt);
        this.addBuiltIn(this.converters, Integer.TYPE, Integer::parseInt);
        this.addBuiltIn(this.converters, Long.class, Long::parseLong);
        this.addBuiltIn(this.converters, Long.TYPE, Long::parseLong);
        this.addBuiltIn(this.converters, Float.class, Float::parseFloat);
        this.addBuiltIn(this.converters, Float.TYPE, Float::parseFloat);
        this.addBuiltIn(this.converters, Double.class, Double::parseDouble);
        this.addBuiltIn(this.converters, Double.TYPE, Double::parseDouble);
        this.addBuiltIn(this.converters, Character.class, MpConfigBuilder::toChar);
        this.addBuiltIn(this.converters, Character.TYPE, MpConfigBuilder::toChar);
        this.addBuiltIn(this.converters, Class.class, MpConfigBuilder::toClass);
        this.addBuiltIn(this.converters, BigDecimal.class, ConfigMappers::toBigDecimal);
        this.addBuiltIn(this.converters, BigInteger.class, ConfigMappers::toBigInteger);
        this.addBuiltIn(this.converters, Duration.class, ConfigMappers::toDuration);
        this.addBuiltIn(this.converters, Period.class, ConfigMappers::toPeriod);
        this.addBuiltIn(this.converters, LocalDate.class, ConfigMappers::toLocalDate);
        this.addBuiltIn(this.converters, LocalDateTime.class, ConfigMappers::toLocalDateTime);
        this.addBuiltIn(this.converters, LocalTime.class, ConfigMappers::toLocalTime);
        this.addBuiltIn(this.converters, ZonedDateTime.class, ConfigMappers::toZonedDateTime);
        this.addBuiltIn(this.converters, ZoneId.class, ConfigMappers::toZoneId);
        this.addBuiltIn(this.converters, ZoneOffset.class, ConfigMappers::toZoneOffset);
        this.addBuiltIn(this.converters, Instant.class, ConfigMappers::toInstant);
        this.addBuiltIn(this.converters, OffsetTime.class, ConfigMappers::toOffsetTime);
        this.addBuiltIn(this.converters, OffsetDateTime.class, ConfigMappers::toOffsetDateTime);
        this.addBuiltIn(this.converters, YearMonth.class, YearMonth::parse);
        this.addBuiltIn(this.converters, File.class, MpConfigBuilder::toFile);
        this.addBuiltIn(this.converters, Path.class, MpConfigBuilder::toPath);
        this.addBuiltIn(this.converters, Charset.class, ConfigMappers::toCharset);
        this.addBuiltIn(this.converters, URI.class, ConfigMappers::toUri);
        this.addBuiltIn(this.converters, URL.class, ConfigMappers::toUrl);
        this.addBuiltIn(this.converters, Pattern.class, ConfigMappers::toPattern);
        this.addBuiltIn(this.converters, UUID.class, ConfigMappers::toUUID);
        this.addBuiltIn(this.converters, Date.class, ConfigMappers::toDate);
        this.addBuiltIn(this.converters, Calendar.class, ConfigMappers::toCalendar);
        this.addBuiltIn(this.converters, GregorianCalendar.class, ConfigMappers::toGregorianCalendar);
        this.addBuiltIn(this.converters, TimeZone.class, ConfigMappers::toTimeZone);
        this.addBuiltIn(this.converters, SimpleTimeZone.class, ConfigMappers::toSimpleTimeZone);
        if (this.useDiscoveredConverters) {
            ServiceLoader.load(Converter.class).forEach(it -> this.converters.add(new OrdinalConverter((Converter<?>)it)));
        }
        if (this.useDiscoveredSources) {
            ServiceLoader.load(ConfigSource.class).forEach(it -> this.sources.add(new OrdinalSource((ConfigSource)it)));
            ServiceLoader.load(ConfigSourceProvider.class).forEach(it -> it.getConfigSources(this.classLoader).forEach(source -> this.sources.add(new OrdinalSource((ConfigSource)source))));
        }
        this.sources.sort(Comparator.comparingInt(o -> o.ordinal));
        this.converters.sort(Comparator.comparingInt(o -> o.ordinal));
        Collections.reverse(this.sources);
        Collections.reverse(this.converters);
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        HashMap converters = new HashMap();
        this.sources.forEach(ordinal -> sources.add(ordinal.source));
        this.converters.forEach(ordinal -> converters.putIfAbsent(ordinal.type, ordinal.converter));
        List filters = HelidonServiceLoader.create(ServiceLoader.load(MpConfigFilter.class)).asList();
        return new MpConfigImpl(sources, converters, filters);
    }

    private <T> void addBuiltIn(List<OrdinalConverter> converters, Class<T> clazz, Converter<T> converter) {
        converters.add(new OrdinalConverter(converter, clazz, 1));
    }

    ConfigBuilder metaConfig(Config metaConfig) {
        Config helidonConfig = Config.builder().config(metaConfig).build();
        this.sources.add(new OrdinalSource(MpConfigSources.create(helidonConfig)));
        return this;
    }

    private static File toFile(String value) {
        return new File(value);
    }

    private static Path toPath(String value) {
        return Paths.get(value, new String[0]);
    }

    private static Class<?> toClass(String stringValue) {
        try {
            return Class.forName(stringValue);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to convert property " + stringValue + " to class", e);
        }
    }

    private static char toChar(String stringValue) {
        if (stringValue.length() != 1) {
            throw new IllegalArgumentException("The string to map must be a single character, but is: " + stringValue);
        }
        return stringValue.charAt(0);
    }

    private static Class<?> getConverterType(Class<?> converterClass) {
        Class<?> type = MpConfigBuilder.doGetType(converterClass);
        if (null == type) {
            throw new IllegalArgumentException("Converter " + converterClass + " must be a ParameterizedType.");
        }
        return type;
    }

    private static Class<?> doGetType(Class<?> clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterizedType.");
            }
            Type typeArgument = typeArguments[0];
            if (typeArgument instanceof Class) {
                return (Class)typeArgument;
            }
            throw new IllegalStateException("Converter " + clazz + " must convert to a class, not " + typeArgument);
        }
        return MpConfigBuilder.doGetType(clazz.getSuperclass());
    }

    private static class OrdinalConverter {
        private final int ordinal;
        private final Class<?> type;
        private final Converter<?> converter;

        private OrdinalConverter(Converter<?> converter, Class<?> aClass, int ordinal) {
            this.ordinal = ordinal;
            this.type = aClass;
            this.converter = converter;
        }

        private OrdinalConverter(Converter<?> converter) {
            this(converter, MpConfigBuilder.getConverterType(converter.getClass()), Priorities.find(converter, (int)100));
        }
    }

    private static class OrdinalSource {
        private final int ordinal;
        private final ConfigSource source;

        private OrdinalSource(ConfigSource source) {
            this.source = source;
            this.ordinal = OrdinalSource.findOrdinal(source);
        }

        private OrdinalSource(ConfigSource source, int ordinal) {
            this.ordinal = ordinal;
            this.source = source;
        }

        private static int findOrdinal(ConfigSource source) {
            int ordinal = source.getOrdinal();
            if (ordinal == 100) {
                return Priorities.find((Object)source, (int)100);
            }
            return ordinal;
        }

        public String toString() {
            return this.ordinal + " " + this.source.getName();
        }
    }
}

