/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.PropertiesFilter;
import jakarta.annotation.Priority;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Priority(value=300)
class MpEnvironmentVariablesSource
implements ConfigSource {
    static final int MY_DEFAULT_ORDINAL = 300;
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String UNDERSCORE = "_";
    private final Map<String, String> env;
    private final Map<String, Cached> cache = new ConcurrentHashMap<String, Cached>();

    MpEnvironmentVariablesSource() {
        this.env = Map.copyOf(PropertiesFilter.create((Properties)System.getProperties()).filter(System.getenv()));
    }

    public Set<String> getPropertyNames() {
        return this.env.keySet();
    }

    public Map<String, String> getProperties() {
        return this.env;
    }

    public String getValue(String propertyName) {
        return this.cache.computeIfAbsent((String)propertyName, (Function<String, Cached>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getValue$0(java.lang.String java.lang.String ), (Ljava/lang/String;)Lio/helidon/config/mp/MpEnvironmentVariablesSource$Cached;)((MpEnvironmentVariablesSource)this, (String)propertyName)).value;
    }

    public int getOrdinal() {
        String configOrdinal = this.getValue("config_ordinal");
        if (configOrdinal == null) {
            return 300;
        }
        return super.getOrdinal();
    }

    public String getName() {
        return "Environment Variables";
    }

    public String toString() {
        return this.getName() + " (" + this.getOrdinal() + ")";
    }

    private static String rule2(String propertyName) {
        return DISALLOWED_CHARS.matcher(propertyName).replaceAll(UNDERSCORE);
    }

    private /* synthetic */ Cached lambda$getValue$0(String propertyName, String theKey) {
        String result = this.env.get(propertyName);
        if (null != result) {
            return new Cached(result);
        }
        String rule2 = MpEnvironmentVariablesSource.rule2(propertyName);
        result = this.env.get(rule2);
        if (null != result) {
            return new Cached(result);
        }
        String rule3 = rule2.toUpperCase();
        result = this.env.get(rule3);
        return new Cached(result);
    }

    private static final class Cached {
        private final String value;

        private Cached(String value) {
            this.value = value;
        }
    }
}

