/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml.mp;

import io.helidon.config.ConfigException;
import io.helidon.config.MutabilitySupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlMpConfigSource
implements ConfigSource {
    private final Map<String, String> properties;
    private final String name;

    private YamlMpConfigSource(String name, Map<String, String> properties) {
        this.properties = properties;
        this.name = "yaml: " + name;
    }

    public static ConfigSource create(Path path) {
        YamlMpConfigSource yamlMpConfigSource;
        block11: {
            String name = path.toAbsolutePath().toString();
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                Map yamlMap = YamlMpConfigSource.toMap(reader);
                Map<String, String> props = YamlMpConfigSource.fromMap(yamlMap == null ? Map.of() : yamlMap);
                if ("true".equals(props.get("helidon.config.polling.enabled"))) {
                    String durationString = props.get("helidon.config.polling.duration");
                    Duration duration = durationString == null ? Duration.ofSeconds(10L) : Duration.parse(durationString);
                    MutabilitySupport.poll((Path)path, (Duration)duration, changed -> YamlMpConfigSource.update(path, props), changed -> props.clear());
                } else if ("true".equals(props.get("helidon.config.watcher.enabled"))) {
                    MutabilitySupport.watch((Path)path, changed -> YamlMpConfigSource.update(path, props), changed -> props.clear());
                }
                yamlMpConfigSource = new YamlMpConfigSource(name, props);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException("Failed to load YAML config source from path: " + path.toAbsolutePath(), (Throwable)e);
                }
            }
            reader.close();
        }
        return yamlMpConfigSource;
    }

    private static void update(Path path, Map<String, String> originalProps) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Map yamlMap = YamlMpConfigSource.toMap(reader);
            Map<String, String> props = YamlMpConfigSource.fromMap(yamlMap == null ? Map.of() : yamlMap);
            originalProps.keySet().removeIf(it -> !props.containsKey(it));
            originalProps.putAll(props);
        }
        catch (IOException e) {
            throw new ConfigException("Failed to load updated YAML config source from path: " + path.toAbsolutePath(), (Throwable)e);
        }
    }

    public static ConfigSource create(URL url) {
        ConfigSource configSource;
        InputStreamReader reader = new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8);
        try {
            configSource = YamlMpConfigSource.create(url.toString(), reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ConfigException("Failed to configure YAML config source", (Throwable)e);
            }
        }
        reader.close();
        return configSource;
    }

    public static ConfigSource create(String name, Reader content) {
        Map yamlMap = YamlMpConfigSource.toMap(content);
        if (yamlMap == null) {
            return new YamlMpConfigSource(name, Map.of());
        }
        return new YamlMpConfigSource(name, YamlMpConfigSource.fromMap(yamlMap));
    }

    public static List<ConfigSource> classPath(String resource) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        try {
            Thread.currentThread().getContextClassLoader().getResources(resource).asIterator().forEachRemaining(it -> sources.add(YamlMpConfigSource.create(it)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read YAML \"" + resource + "\" from classpath", e);
        }
        return sources;
    }

    public static List<ConfigSource> classPath(String resource, String profile) {
        return YamlMpConfigSource.classPathConfigSources(resource, profile, Thread.currentThread().getContextClassLoader());
    }

    public static List<ConfigSource> classPath(String resource, String profile, ClassLoader classLoader) {
        Objects.requireNonNull(profile, "Profile must be defined");
        Objects.requireNonNull(classLoader, "ClassLoader must be defined");
        return YamlMpConfigSource.classPathConfigSources(resource, profile, classLoader);
    }

    private static List<ConfigSource> classPathConfigSources(String resource, String profile, ClassLoader classLoader) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        try {
            Enumeration<URL> baseResources = classLoader.getResources(resource);
            Enumeration<URL> profileResources = classLoader.getResources(YamlMpConfigSource.toProfileResource(resource, profile));
            if (profileResources.hasMoreElements()) {
                LinkedList profileResourceList = new LinkedList();
                profileResources.asIterator().forEachRemaining(profileResourceList::add);
                baseResources.asIterator().forEachRemaining(it -> {
                    String pathBase = YamlMpConfigSource.pathBase(it.toString());
                    for (URL url : profileResourceList) {
                        String profilePathBase = YamlMpConfigSource.pathBase(url.toString());
                        if (pathBase.equals(profilePathBase)) {
                            sources.add(YamlMpConfigSource.create(YamlMpConfigSource.create(url), YamlMpConfigSource.create(it)));
                            continue;
                        }
                        sources.add(YamlMpConfigSource.create(it));
                    }
                });
            } else {
                baseResources.asIterator().forEachRemaining(it -> sources.add(YamlMpConfigSource.create(it)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read YAML \"" + resource + "\" from classpath", e);
        }
        return sources;
    }

    private static ConfigSource create(final ConfigSource main, final ConfigSource fallback) {
        final String name = main.getName() + " (" + fallback.getName() + ")";
        return new ConfigSource(){

            public Set<String> getPropertyNames() {
                HashSet<String> result = new HashSet<String>(fallback.getPropertyNames());
                result.addAll(main.getPropertyNames());
                return result;
            }

            public String getValue(String propertyName) {
                String value = main.getValue(propertyName);
                if (value == null) {
                    return fallback.getValue(propertyName);
                }
                return value;
            }

            public String getName() {
                return name;
            }

            public Map<String, String> getProperties() {
                HashMap<String, String> result = new HashMap<String, String>(fallback.getProperties());
                result.putAll(main.getProperties());
                return result;
            }
        };
    }

    private static Map<String, String> fromMap(Map yamlMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        YamlMpConfigSource.process(result, "", yamlMap);
        return result;
    }

    private static void process(Map<String, String> resultMap, String prefix, Map yamlMap) {
        yamlMap.forEach((key, value) -> YamlMpConfigSource.processNext(resultMap, YamlMpConfigSource.prefix(prefix, key.toString()), value));
    }

    private static void process(Map<String, String> resultMap, String prefix, List yamlList) {
        int counter = 0;
        for (Object value : yamlList) {
            YamlMpConfigSource.processNext(resultMap, YamlMpConfigSource.prefix(prefix, String.valueOf(counter)), value);
            ++counter;
        }
    }

    private static void processNext(Map<String, String> resultMap, String prefix, Object value) {
        if (value instanceof List) {
            YamlMpConfigSource.process(resultMap, prefix, (List)value);
        } else if (value instanceof Map) {
            YamlMpConfigSource.process(resultMap, prefix, (Map)value);
        } else {
            String stringValue = null == value ? "" : value.toString();
            resultMap.put(prefix, stringValue);
        }
    }

    private static String prefix(String prefix, String stringKey) {
        if (prefix.isEmpty()) {
            return stringKey;
        }
        return prefix + "." + stringKey;
    }

    private static String pathBase(String path) {
        int i = path.lastIndexOf(47);
        int y = path.lastIndexOf(33);
        int z = path.lastIndexOf(58);
        int b = path.lastIndexOf(92);
        int max = Math.max(i, y);
        max = Math.max(max, z);
        if ((max = Math.max(max, b)) > -1) {
            return path.substring(0, max);
        }
        return path;
    }

    private static String toProfileResource(String resource, String profile) {
        int i = resource.lastIndexOf(46);
        if (i > -1) {
            return resource.substring(0, i) + "-" + profile + resource.substring(i);
        }
        return resource + "-" + profile;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    static Map toMap(Reader reader) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        return (Map)yaml.loadAs(reader, Object.class);
    }
}

