/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml.internal;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@Priority(value=200)
public class YamlConfigParser
implements ConfigParser {
    public static final String MEDIA_TYPE_APPLICATION_YAML = "application/x-yaml";
    public static final int PRIORITY = 200;
    private static final Set<String> SUPPORTED_MEDIA_TYPES = CollectionsHelper.setOf((Object[])new String[]{"application/x-yaml"});

    public YamlConfigParser() {
        if (System.getProperty("java.runtime.name") == null) {
            System.setProperty("java.runtime.name", "unknown");
        }
    }

    public Set<String> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> ConfigNode.ObjectNode parse(ConfigParser.Content<S> content) throws ConfigParserException {
        try (AutoCloseable readable = (AutoCloseable)((Object)content.asReadable());){
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map yamlMap = (Map)yaml.loadAs(ConfigHelper.createReader((Readable)((Readable)((Object)readable))), Object.class);
            if (yamlMap == null) {
                ConfigNode.ObjectNode objectNode2 = ConfigNode.ObjectNode.empty();
                return objectNode2;
            }
            ConfigNode.ObjectNode objectNode = YamlConfigParser.fromMap(yamlMap);
            return objectNode;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static ConfigNode.ObjectNode fromMap(Map<?, ?> map) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        if (map != null) {
            map.forEach((k, v) -> {
                String strKey = k.toString();
                if (v instanceof List) {
                    builder.addList(strKey, YamlConfigParser.fromList((List)v));
                } else if (v instanceof Map) {
                    builder.addObject(strKey, YamlConfigParser.fromMap((Map)v));
                } else {
                    String strValue = v == null ? "" : v.toString();
                    builder.addValue(strKey, strValue);
                }
            });
        }
        return builder.build();
    }

    private static ConfigNode.ListNode fromList(List<?> list) {
        ConfigNode.ListNode.Builder builder = ConfigNode.ListNode.builder();
        list.forEach(value -> {
            if (value instanceof List) {
                builder.addList(YamlConfigParser.fromList((List)value));
            } else if (value instanceof Map) {
                builder.addObject(YamlConfigParser.fromMap((Map)value));
            } else {
                String strValue = value == null ? "" : value.toString();
                builder.addValue(strValue);
            }
        });
        return (ConfigNode.ListNode)builder.build();
    }
}

