/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml;

import io.helidon.config.ConfigException;
import io.helidon.config.yaml.YamlConfigParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class YamlMpConfigSource
implements ConfigSource {
    private final Map<String, String> properties;
    private final String name;

    private YamlMpConfigSource(String name, Map<String, String> properties) {
        this.properties = properties;
        this.name = "yaml: " + name;
    }

    public static ConfigSource create(Path path) {
        try {
            return YamlMpConfigSource.create(path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Failed to load YAML config source from path: " + path.toAbsolutePath(), (Throwable)e);
        }
    }

    public static ConfigSource create(URL url) {
        ConfigSource configSource;
        InputStreamReader reader = new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8);
        try {
            configSource = YamlMpConfigSource.create(url.toString(), reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ConfigException("Failed to configure YAML config source", (Throwable)e);
            }
        }
        reader.close();
        return configSource;
    }

    public static ConfigSource create(String name, Reader content) {
        Map yamlMap = YamlConfigParser.toMap(content);
        if (yamlMap == null) {
            return new YamlMpConfigSource(name, Map.of());
        }
        return new YamlMpConfigSource(name, YamlMpConfigSource.fromMap(yamlMap));
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    private static Map<String, String> fromMap(Map yamlMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        YamlMpConfigSource.process(result, "", yamlMap);
        return result;
    }

    private static void process(Map<String, String> resultMap, String prefix, Map yamlMap) {
        yamlMap.forEach((key, value) -> YamlMpConfigSource.processNext(resultMap, YamlMpConfigSource.prefix(prefix, key.toString()), value));
    }

    private static void process(Map<String, String> resultMap, String prefix, List yamlList) {
        int counter = 0;
        for (Object value : yamlList) {
            YamlMpConfigSource.processNext(resultMap, YamlMpConfigSource.prefix(prefix, String.valueOf(counter)), value);
            ++counter;
        }
    }

    private static void processNext(Map<String, String> resultMap, String prefix, Object value) {
        if (value instanceof List) {
            YamlMpConfigSource.process(resultMap, prefix, (List)value);
        } else if (value instanceof Map) {
            YamlMpConfigSource.process(resultMap, prefix, (Map)value);
        } else {
            String stringValue = null == value ? "" : value.toString();
            resultMap.put(prefix, stringValue);
        }
    }

    private static String prefix(String prefix, String stringKey) {
        if (prefix.isEmpty()) {
            return stringKey;
        }
        return prefix + "." + stringKey;
    }
}

