/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml;

import io.helidon.config.ConfigException;
import io.helidon.config.yaml.YamlMpConfigSource;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class YamlMpConfigSourceProvider
implements ConfigSourceProvider {
    public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = classLoader.getResources("application.yaml");
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read resources from classpath", (Throwable)e);
        }
        LinkedList<ConfigSource> result = new LinkedList<ConfigSource>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            result.add(YamlMpConfigSource.create(url));
        }
        return result;
    }
}

