/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.GenericType;
import io.helidon.common.reactive.Flow;
import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigSources;
import io.helidon.config.EnvironmentVariableAliases;
import io.helidon.config.OverrideSources;
import io.helidon.config.ProviderImpl;
import io.helidon.config.UseFirstAvailableConfigSource;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Priority;

class BuilderImpl
implements Config.Builder {
    static final Executor DEFAULT_CHANGES_EXECUTOR = Executors.newCachedThreadPool(new ConfigThreadFactory("config"));
    private static final List<String> DEFAULT_FILE_EXTENSIONS = Arrays.asList("yaml", "conf", "json", "properties");
    private List<ConfigSource> sources = null;
    private final ConfigMapperManager.MapperProviders mapperProviders;
    private boolean mapperServicesEnabled = true;
    private final List<ConfigParser> parsers;
    private boolean parserServicesEnabled = true;
    private final List<Function<Config, ConfigFilter>> filterProviders;
    private boolean filterServicesEnabled = true;
    private boolean cachingEnabled = true;
    private Executor changesExecutor;
    private int changesMaxBuffer;
    private boolean keyResolving = true;
    private boolean systemPropertiesSourceEnabled = true;
    private boolean environmentVariablesSourceEnabled = true;
    private OverrideSource overrideSource = OverrideSources.empty();
    private boolean envVarAliasGeneratorEnabled = false;

    BuilderImpl() {
        this.mapperProviders = ConfigMapperManager.MapperProviders.create();
        this.parsers = new ArrayList<ConfigParser>();
        this.filterProviders = new ArrayList<Function<Config, ConfigFilter>>();
        this.changesExecutor = DEFAULT_CHANGES_EXECUTOR;
        this.changesMaxBuffer = Flow.defaultBufferSize();
    }

    @Override
    public Config.Builder sources(List<Supplier<ConfigSource>> sourceSuppliers) {
        this.sources = new ArrayList<ConfigSource>(sourceSuppliers.size());
        sourceSuppliers.stream().map(Supplier::get).forEach(source -> {
            this.sources.add((ConfigSource)source);
            if (source.description().contains("env-vars")) {
                this.envVarAliasGeneratorEnabled = true;
            }
        });
        return this;
    }

    @Override
    public Config.Builder overrides(Supplier<OverrideSource> overridingSource) {
        this.overrideSource = overridingSource.get();
        return this;
    }

    @Override
    public Config.Builder disableMapperServices() {
        this.mapperServicesEnabled = false;
        return this;
    }

    @Override
    public <T> Config.Builder addStringMapper(Class<T> type, Function<String, T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        this.addMapper(type, (Config config) -> mapper.apply(config.asString().get()));
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(Class<T> type, Function<Config, T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        this.addMapper(() -> CollectionsHelper.mapOf((Object)type, (Object)mapper));
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(final GenericType<T> type, final Function<Config, T> mappingFunction) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mappingFunction);
        this.addMapper(new ConfigMapperProvider(){

            @Override
            public Map<Class<?>, Function<Config, ?>> mappers() {
                return CollectionsHelper.mapOf();
            }

            @Override
            public Map<GenericType<?>, BiFunction<Config, ConfigMapper, ?>> genericTypeMappers() {
                return CollectionsHelper.mapOf((Object)type, (config, aMapper) -> mappingFunction.apply(config));
            }
        });
        return this;
    }

    @Override
    public Config.Builder addMapper(ConfigMapperProvider mapperProvider) {
        Objects.requireNonNull(mapperProvider);
        this.mapperProviders.add(mapperProvider);
        return this;
    }

    @Override
    public Config.Builder addParser(ConfigParser configParser) {
        Objects.requireNonNull(configParser);
        this.parsers.add(configParser);
        return this;
    }

    @Override
    public Config.Builder disableParserServices() {
        this.parserServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder addFilter(ConfigFilter configFilter) {
        Objects.requireNonNull(configFilter);
        this.filterProviders.add(config -> configFilter);
        return this;
    }

    @Override
    public Config.Builder addFilter(Function<Config, ConfigFilter> configFilterProvider) {
        Objects.requireNonNull(configFilterProvider);
        this.filterProviders.add(configFilterProvider);
        return this;
    }

    @Override
    public Config.Builder addFilter(Supplier<Function<Config, ConfigFilter>> configFilterSupplier) {
        Objects.requireNonNull(configFilterSupplier);
        this.filterProviders.add(configFilterSupplier.get());
        return this;
    }

    @Override
    public Config.Builder disableFilterServices() {
        this.filterServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableCaching() {
        this.cachingEnabled = false;
        return this;
    }

    @Override
    public Config.Builder changesExecutor(Executor changesExecutor) {
        Objects.requireNonNull(changesExecutor);
        this.changesExecutor = changesExecutor;
        return this;
    }

    @Override
    public Config.Builder changesMaxBuffer(int changesMaxBuffer) {
        this.changesMaxBuffer = changesMaxBuffer;
        return this;
    }

    @Override
    public Config.Builder disableKeyResolving() {
        this.keyResolving = false;
        return this;
    }

    @Override
    public Config.Builder disableValueResolving() {
        return this;
    }

    @Override
    public Config.Builder disableEnvironmentVariablesSource() {
        this.environmentVariablesSourceEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableSystemPropertiesSource() {
        this.systemPropertiesSourceEnabled = false;
        return this;
    }

    @Override
    public Config build() {
        return this.buildProvider().newConfig();
    }

    @Override
    public Config.Builder mappersFrom(Config config) {
        if (!(config instanceof AbstractConfigImpl)) {
            throw new ConfigException("Unexpected configuration implementation used to copy mappers: " + config.getClass().getName());
        }
        final ConfigMapperManager mapperManager = ((AbstractConfigImpl)config).mapperManager();
        this.addMapper(new ConfigMapperProvider(){

            @Override
            public Map<Class<?>, Function<Config, ?>> mappers() {
                return CollectionsHelper.mapOf();
            }

            @Override
            public <T> Optional<BiFunction<Config, ConfigMapper, T>> mapper(GenericType<T> type) {
                Optional<BiFunction<Config, ConfigMapper, Object>> mapper = mapperManager.mapper(type);
                return Optional.ofNullable(mapper.orElse(null));
            }
        });
        return this;
    }

    private ProviderImpl buildProvider() {
        ConfigContextImpl context = new ConfigContextImpl(BuilderImpl.buildParsers(this.parserServicesEnabled, this.parsers));
        ConfigSource targetConfigSource = this.targetConfigSource(context);
        ConfigMapperManager configMapperManager = BuilderImpl.buildMappers(this.mapperServicesEnabled, this.mapperProviders);
        if (this.filterServicesEnabled) {
            this.addAutoLoadedFilters();
        }
        Function<String, List<String>> aliasGenerator = this.envVarAliasGeneratorEnabled ? EnvironmentVariableAliases::aliasesOf : null;
        return this.createProvider(configMapperManager, targetConfigSource, this.overrideSource, this.filterProviders, this.cachingEnabled, this.changesExecutor, this.changesMaxBuffer, this.keyResolving, aliasGenerator);
    }

    private ConfigSource targetConfigSource(ConfigContext context) {
        LinkedList<ConfigSource> targetSources = new LinkedList<ConfigSource>();
        if (this.environmentVariablesSourceEnabled) {
            targetSources.add(ConfigSources.environmentVariables());
            this.envVarAliasGeneratorEnabled = true;
        }
        if (this.systemPropertiesSourceEnabled) {
            targetSources.add(ConfigSources.systemProperties());
        }
        if (this.sources != null) {
            targetSources.addAll(this.sources);
        } else {
            targetSources.add(BuilderImpl.defaultConfigSource());
        }
        ConfigSource targetConfigSource = targetSources.size() == 1 ? (ConfigSource)targetSources.get(0) : ConfigSources.create(targetSources.toArray(new ConfigSource[0])).build();
        targetConfigSource.init(context);
        return targetConfigSource;
    }

    ProviderImpl createProvider(ConfigMapperManager configMapperManager, ConfigSource targetConfigSource, OverrideSource overrideSource, List<Function<Config, ConfigFilter>> filterProviders, boolean cachingEnabled, Executor changesExecutor, int changesMaxBuffer, boolean keyResolving, Function<String, List<String>> aliasGenerator) {
        return new ProviderImpl(configMapperManager, targetConfigSource, overrideSource, filterProviders, cachingEnabled, changesExecutor, changesMaxBuffer, keyResolving, aliasGenerator);
    }

    private static ConfigSource defaultConfigSource() {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        List<ConfigSource> meta = BuilderImpl.defaultConfigSources(classLoader, "meta-config");
        if (!meta.isEmpty()) {
            sources.add(ConfigSources.load(BuilderImpl.toDefaultConfigSource(meta)).build());
        }
        sources.addAll(BuilderImpl.defaultConfigSources(classLoader, "application"));
        return ConfigSources.create(BuilderImpl.toDefaultConfigSource(sources)).build();
    }

    private static List<ConfigSource> defaultConfigSources(ClassLoader classLoader, String baseResourceName) {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        for (String extension : DEFAULT_FILE_EXTENSIONS) {
            String resource = baseResourceName + "." + extension;
            if (classLoader.getResource(resource) == null) continue;
            sources.add((ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath(resource).optional()).build());
        }
        return sources;
    }

    private static ConfigSource toDefaultConfigSource(List<ConfigSource> sources) {
        if (sources.isEmpty()) {
            return ConfigSources.empty();
        }
        if (sources.size() == 1) {
            return sources.get(0);
        }
        return new UseFirstAvailableConfigSource(sources);
    }

    static List<ConfigParser> buildParsers(boolean servicesEnabled, List<ConfigParser> userDefinedParsers) {
        LinkedList<ConfigParser> parsers = new LinkedList<ConfigParser>(userDefinedParsers);
        if (servicesEnabled) {
            parsers.addAll(BuilderImpl.loadParserServices());
        }
        return parsers;
    }

    static ConfigMapperManager buildMappers(boolean servicesEnabled, ConfigMapperManager.MapperProviders userDefinedProviders) {
        ConfigMapperManager.MapperProviders providers = ConfigMapperManager.MapperProviders.create();
        List<ConfigMapperProvider> prioritizedProviders = new LinkedList<ConfigMapperProvider>();
        prioritizedProviders.add(new InternalPriorityMapperProvider(ConfigMappers.essentialMappers()));
        prioritizedProviders.add(new InternalPriorityMapperProvider(ConfigMappers.builtInMappers()));
        if (servicesEnabled) {
            BuilderImpl.loadMapperServices(prioritizedProviders);
        }
        prioritizedProviders = ConfigUtils.asPrioritizedStream(prioritizedProviders, 100).collect(Collectors.toList());
        prioritizedProviders.forEach(providers::add);
        providers.addAll(userDefinedProviders);
        return new ConfigMapperManager(providers);
    }

    private static void loadMapperServices(List<ConfigMapperProvider> providers) {
        ServiceLoader.load(ConfigMapperProvider.class).forEach(providers::add);
    }

    private static List<ConfigParser> loadParserServices() {
        return BuilderImpl.loadPrioritizedServices(ConfigParser.class, 100);
    }

    private void addAutoLoadedFilters() {
        ConfigUtils.asStream(ServiceLoader.load(ConfigFilter.class).iterator()).map(filter -> t -> filter).forEach(this::addFilter);
    }

    private static <T> List<T> loadPrioritizedServices(Class<T> serviceClass, int priority) {
        return ConfigUtils.asPrioritizedStream(ServiceLoader.load(serviceClass), priority).collect(Collectors.toList());
    }

    @Priority(value=200)
    static class InternalPriorityMapperProvider
    implements ConfigMapperProvider {
        private final Map<Class<?>, Function<Config, ?>> converterMap;

        InternalPriorityMapperProvider(Map<Class<?>, Function<Config, ?>> converterMap) {
            this.converterMap = converterMap;
        }

        @Override
        public Map<Class<?>, Function<Config, ?>> mappers() {
            return this.converterMap;
        }
    }

    static final class EmptyConfigHolder {
        static final Config EMPTY = new BuilderImpl().sources(ConfigSources.empty()).overrides(OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableParserServices().disableFilterServices().build();

        private EmptyConfigHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    static class ConfigContextImpl
    implements ConfigContext {
        private final List<ConfigParser> configParsers;

        ConfigContextImpl(List<ConfigParser> configParsers) {
            this.configParsers = configParsers;
        }

        @Override
        public Optional<ConfigParser> findParser(String mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("Unknown media type of resource.");
            }
            return this.configParsers.stream().filter(parser -> parser.supportedMediaTypes().contains(mediaType)).findFirst();
        }
    }
}

