/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.FileSourceHelper;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileConfigSource
extends AbstractParsableConfigSource<byte[]> {
    private static final Logger LOGGER = Logger.getLogger(FileConfigSource.class.getName());
    private static final String PATH_KEY = "path";
    private final Path filePath;

    FileConfigSource(FileBuilder builder, Path filePath) {
        super(builder);
        this.filePath = filePath;
    }

    public static FileConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return (FileConfigSource)new FileBuilder(metaConfig.get(PATH_KEY).as(Path.class).get()).init(metaConfig).build();
    }

    @Override
    protected String uid() {
        return this.filePath.toString();
    }

    @Override
    protected String mediaType() {
        return OptionalHelper.from(Optional.ofNullable(super.mediaType())).or(this::probeContentType).asOptional().orElse(null);
    }

    private Optional<String> probeContentType() {
        return Optional.ofNullable(ConfigHelper.detectContentType(this.filePath));
    }

    @Override
    protected Optional<byte[]> dataStamp() {
        return Optional.ofNullable(FileSourceHelper.digest(this.filePath));
    }

    @Override
    protected ConfigParser.Content<byte[]> content() throws ConfigException {
        Optional<byte[]> stamp = this.dataStamp();
        LOGGER.log(Level.FINE, String.format("Getting content from '%s'", this.filePath));
        return ConfigParser.Content.create(new StringReader(FileSourceHelper.safeReadContent(this.filePath)), this.mediaType(), stamp);
    }

    public static final class FileBuilder
    extends AbstractParsableConfigSource.Builder<FileBuilder, Path> {
        private Path path;

        public FileBuilder(Path path) {
            super(Path.class);
            Objects.requireNonNull(path, "file path cannot be null");
            this.path = path;
        }

        @Override
        protected FileBuilder init(Config metaConfig) {
            return (FileBuilder)super.init(metaConfig);
        }

        @Override
        protected Path target() {
            return this.path;
        }

        @Override
        public ConfigSource build() {
            return new FileConfigSource(this, this.path);
        }

        PollingStrategy pollingStrategyInternal() {
            return super.pollingStrategy();
        }
    }
}

