/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ConfigDiff {
    private final Config config;
    private final Set<Config.Key> changedKeys;

    private ConfigDiff(Config config, Set<Config.Key> changedKeys) {
        this.config = config;
        this.changedKeys = changedKeys;
    }

    static ConfigDiff from(Config origConfig, Config newConfig) {
        Stream<Config> forward = origConfig.traverse().filter(origNode -> ConfigDiff.notEqual(origNode, newConfig.get(origNode.key())));
        Stream<Config> backward = newConfig.traverse().filter(newNode -> ConfigDiff.notEqual(newNode, origConfig.get(newNode.key())));
        Set<Config.Key> changedKeys = Stream.concat(forward, backward).map(Config::key).distinct().flatMap(ConfigDiff::expandKey).distinct().collect(Collectors.toSet());
        return new ConfigDiff(newConfig, changedKeys);
    }

    private static Stream<Config.Key> expandKey(Config.Key key) {
        HashSet<Config.Key> keys = new HashSet<Config.Key>();
        ConfigDiff.expandKey(key, keys);
        return keys.stream();
    }

    private static void expandKey(Config.Key key, Set<Config.Key> keys) {
        keys.add(key);
        if (!key.isRoot()) {
            ConfigDiff.expandKey(key.parent(), keys);
        }
    }

    private static boolean notEqual(Config left, Config right) {
        if (left.type() != right.type()) {
            return true;
        }
        if (left.isLeaf()) {
            return !ConfigDiff.value(left).equals(ConfigDiff.value(right));
        }
        return false;
    }

    private static Optional<String> value(Config node) {
        if (node instanceof AbstractConfigImpl) {
            return ((AbstractConfigImpl)node).value();
        }
        return node.asString().asOptional();
    }

    boolean isEmpty() {
        return this.changedKeys.isEmpty();
    }

    Set<Config.Key> changedKeys() {
        return this.changedKeys;
    }

    Config config() {
        return this.config;
    }
}

