/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClasspathSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(ClasspathSourceHelper.class.getName());

    private ClasspathSourceHelper() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    static String uid(String resourceName) {
        try {
            Path resourcePath = ClasspathSourceHelper.resourcePath(resourceName);
            if (resourcePath != null) {
                return resourcePath.toString().replace('\\', '/');
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Not possible to get filesystem path for resource '" + resourceName + "'. Resource's name is used as ConfigSource URI.", ex);
        }
        return resourceName;
    }

    static Path resourcePath(String resourceName) throws URISyntaxException {
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resourceUrl != null) {
            URI uri = resourceUrl.toURI();
            if ("file".equals(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        return null;
    }

    static Instant resourceTimestamp(String resourceName) {
        try {
            Path resourcePath = ClasspathSourceHelper.resourcePath(resourceName);
            if (resourcePath != null) {
                return Files.getLastModifiedTime(resourcePath, new LinkOption[0]).toInstant();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error to get resource '" + resourceName + "' last modified time.", ex);
        }
        return Instant.EPOCH;
    }
}

