/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlConfigSource
extends AbstractParsableConfigSource<Instant> {
    private static final Logger LOGGER = Logger.getLogger(UrlConfigSource.class.getName());
    private static final String HEAD_METHOD = "HEAD";
    private static final String GET_METHOD = "GET";
    private static final String URL_KEY = "url";
    private final URL url;

    UrlConfigSource(UrlBuilder builder, URL url) {
        super(builder);
        this.url = url;
    }

    public static UrlConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return (UrlConfigSource)new UrlBuilder(metaConfig.get(URL_KEY).as(URL.class).get()).init(metaConfig).build();
    }

    @Override
    protected String uid() {
        return this.url.toString();
    }

    @Override
    protected ConfigParser.Content<Instant> content() throws ConfigException {
        try {
            URLConnection urlConnection = this.url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                return this.httpContent((HttpURLConnection)urlConnection);
            }
            return this.genericContent(urlConnection);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at url '" + this.url + "' GET is not accessible.", ex);
        }
    }

    private ConfigParser.Content<Instant> genericContent(URLConnection urlConnection) throws IOException, URISyntaxException {
        String mediaType = this.mediaType(null);
        InputStreamReader reader = new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8);
        return ConfigParser.Content.create(reader, mediaType, Optional.of(Instant.now()));
    }

    private ConfigParser.Content<Instant> httpContent(HttpURLConnection connection) throws IOException, URISyntaxException {
        Optional<Instant> timestamp;
        connection.setRequestMethod(GET_METHOD);
        String mediaType = this.mediaType(connection.getContentType());
        if (connection.getLastModified() != 0L) {
            timestamp = Optional.of(Instant.ofEpochMilli(connection.getLastModified()));
        } else {
            timestamp = Optional.of(Instant.now());
            LOGGER.fine("Missing GET '" + this.url + "' response header 'Last-Modified'. Used current time '" + timestamp + "' as a content timestamp.");
        }
        InputStreamReader reader = new InputStreamReader(connection.getInputStream(), ConfigUtils.getContentCharset(connection.getContentEncoding()));
        return ConfigParser.Content.create(reader, mediaType, timestamp);
    }

    @Override
    protected String mediaType() {
        return super.mediaType();
    }

    private String mediaType(String responseMediaType) throws URISyntaxException {
        String mediaType = this.mediaType();
        if (mediaType == null && (mediaType = responseMediaType) == null) {
            mediaType = this.probeContentType();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("HTTP response does not contain content-type, used guessed one: " + mediaType + ".");
            }
        }
        return mediaType;
    }

    private String probeContentType() throws URISyntaxException {
        Path path;
        URI uri = this.url.toURI();
        switch (uri.getScheme()) {
            case "jar": {
                String relativePath = uri.getSchemeSpecificPart();
                int idx = relativePath.indexOf("!");
                if (idx > 0 && idx < relativePath.length()) {
                    relativePath = relativePath.substring(idx + 1);
                }
                path = Paths.get(relativePath, new String[0]);
                break;
            }
            case "file": {
                path = Paths.get(uri);
                break;
            }
            default: {
                path = Paths.get(this.url.getPath(), new String[0]);
            }
        }
        return ConfigHelper.detectContentType(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<Instant> dataStamp() {
        block6: {
            try {
                URLConnection urlConnection = this.url.openConnection();
                if (!(urlConnection instanceof HttpURLConnection)) break block6;
                HttpURLConnection connection = (HttpURLConnection)urlConnection;
                try {
                    connection.setRequestMethod(HEAD_METHOD);
                    if (connection.getLastModified() != 0L) {
                        Optional<Instant> optional = Optional.of(Instant.ofEpochMilli(connection.getLastModified()));
                        return optional;
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, ex, () -> "Configuration at url '" + this.url + "' HEAD is not accessible.");
            }
        }
        Optional<Instant> timestamp = Optional.of(Instant.MAX);
        LOGGER.finer("Missing HEAD '" + this.url + "' response header 'Last-Modified'. Used time '" + timestamp + "' as a content timestamp.");
        return timestamp;
    }

    public static final class UrlBuilder
    extends AbstractParsableConfigSource.Builder<UrlBuilder, URL> {
        private URL url;

        public UrlBuilder(URL url) {
            super(URL.class);
            Objects.requireNonNull(url, "url cannot be null");
            this.url = url;
        }

        @Override
        protected UrlBuilder init(Config metaConfig) {
            return (UrlBuilder)super.init(metaConfig);
        }

        @Override
        protected URL target() {
            return this.url;
        }

        @Override
        public ConfigSource build() {
            return new UrlConfigSource(this, this.url);
        }

        PollingStrategy pollingStrategyInternal() {
            return super.pollingStrategy();
        }
    }
}

