/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigDiff;
import io.helidon.config.ConfigLeafImpl;
import io.helidon.config.ConfigListImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMissingImpl;
import io.helidon.config.ConfigObjectImpl;
import io.helidon.config.ProviderImpl;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class ConfigFactory {
    private final ConfigMapperManager mapperManager;
    private final Map<ConfigKeyImpl, ConfigNode> fullKeyToNodeMap;
    private final ConfigFilter filter;
    private final ProviderImpl provider;
    private final Function<String, List<String>> aliasGenerator;
    private final ConcurrentMap<PrefixedKey, Config> configCache;
    private final Flow.Publisher<ConfigDiff> changesPublisher;
    private final Instant timestamp;

    ConfigFactory(ConfigMapperManager mapperManager, ConfigNode.ObjectNode node, ConfigFilter filter, ProviderImpl provider, Function<String, List<String>> aliasGenerator) {
        Objects.requireNonNull(mapperManager, "mapperManager argument is null.");
        Objects.requireNonNull(node, "node argument is null.");
        Objects.requireNonNull(filter, "filter argument is null.");
        Objects.requireNonNull(provider, "provider argument is null.");
        this.mapperManager = mapperManager;
        this.fullKeyToNodeMap = ConfigFactory.createFullKeyToNodeMap(node);
        this.filter = filter;
        this.provider = provider;
        this.aliasGenerator = aliasGenerator;
        this.configCache = new ConcurrentHashMap<PrefixedKey, Config>();
        this.changesPublisher = new FilteringConfigChangeEventPublisher(provider.changes());
        this.timestamp = Instant.now();
    }

    private static Map<ConfigKeyImpl, ConfigNode> createFullKeyToNodeMap(ConfigNode.ObjectNode objectNode) {
        Stream flattenNodes = objectNode.entrySet().stream().map(node -> ConfigFactory.flattenNodes(ConfigKeyImpl.of((String)node.getKey()), (ConfigNode)node.getValue())).reduce(Stream.empty(), Stream::concat);
        Map<ConfigKeyImpl, ConfigNode> result = flattenNodes.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.put(ConfigKeyImpl.of(), objectNode);
        return result;
    }

    static Stream<Map.Entry<ConfigKeyImpl, ConfigNode>> flattenNodes(ConfigKeyImpl key, ConfigNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return ((ConfigNode.ObjectNode)node).entrySet().stream().map(e -> ConfigFactory.flattenNodes(key.child((String)e.getKey()), (ConfigNode)e.getValue())).reduce(Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node)), Stream::concat);
            }
            case LIST: {
                return IntStream.range(0, ((ConfigNode.ListNode)node).size()).boxed().map(i -> ConfigFactory.flattenNodes(key.child(Integer.toString(i)), (ConfigNode)((ConfigNode.ListNode)node).get((int)i))).reduce(Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node)), Stream::concat);
            }
            case VALUE: {
                return Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node));
            }
        }
        throw new IllegalArgumentException("Invalid node type.");
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Config config() {
        return this.config(ConfigKeyImpl.of(), ConfigKeyImpl.of());
    }

    public Config config(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        PrefixedKey prefixedKey = new PrefixedKey(prefix, key);
        return this.configCache.computeIfAbsent(prefixedKey, it -> this.createConfig(prefix, key));
    }

    private Config createConfig(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigNode value = this.findNode(prefix, key);
        if (null == value) {
            return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
        }
        switch (value.nodeType()) {
            case OBJECT: {
                return new ConfigObjectImpl(prefix, key, (ConfigNode.ObjectNode)value, this.filter, this, this.mapperManager);
            }
            case LIST: {
                return new ConfigListImpl(prefix, key, (ConfigNode.ListNode)value, this.filter, this, this.mapperManager);
            }
            case VALUE: {
                return new ConfigLeafImpl(prefix, key, (ConfigNode.ValueNode)value, this.filter, this, this.mapperManager);
            }
        }
        return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
    }

    private ConfigNode findNode(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigNode node;
        block1: {
            String keyAlias;
            node = this.fullKeyToNodeMap.get(prefix.child(key));
            if (node != null || this.aliasGenerator == null) break block1;
            String fullKey = key.toString();
            Iterator<String> iterator = this.aliasGenerator.apply(fullKey).iterator();
            while (iterator.hasNext() && (node = this.fullKeyToNodeMap.get(prefix.child(keyAlias = iterator.next()))) == null) {
            }
        }
        return node;
    }

    public Flow.Publisher<ConfigDiff> changes() {
        return this.changesPublisher;
    }

    Config.Context context() {
        return this.provider;
    }

    ProviderImpl provider() {
        return this.provider;
    }

    private static final class PrefixedKey {
        private final ConfigKeyImpl prefix;
        private final ConfigKeyImpl key;

        private PrefixedKey(ConfigKeyImpl prefix, ConfigKeyImpl key) {
            this.prefix = prefix;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixedKey that = (PrefixedKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.key);
        }
    }

    private class FilteringConfigChangeEventSubscriber
    implements Flow.Subscriber<ConfigDiff> {
        private final Flow.Subscriber<? super ConfigDiff> delegate;
        private Flow.Subscription subscription;

        private FilteringConfigChangeEventSubscriber(Flow.Subscriber<? super ConfigDiff> delegate) {
            this.delegate = delegate;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.delegate.onSubscribe(subscription);
        }

        public void onNext(ConfigDiff event) {
            if (ConfigFactory.this.config() == event.config()) {
                this.subscription.request(1L);
            } else {
                this.delegate.onNext((Object)event);
            }
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    private class FilteringConfigChangeEventPublisher
    implements Flow.Publisher<ConfigDiff> {
        private Flow.Publisher<ConfigDiff> delegate;

        private FilteringConfigChangeEventPublisher(Flow.Publisher<ConfigDiff> delegate) {
            this.delegate = delegate;
        }

        public void subscribe(Flow.Subscriber<? super ConfigDiff> subscriber) {
            this.delegate.subscribe((Flow.Subscriber)new FilteringConfigChangeEventSubscriber(subscriber));
        }
    }
}

