/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.Builder;
import io.helidon.common.CollectionsHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.config.CompositeConfigSource;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigValue;
import io.helidon.config.EnvironmentVariables;
import io.helidon.config.FallbackMergingStrategy;
import io.helidon.config.InMemoryConfigSource;
import io.helidon.config.internal.ClasspathConfigSource;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.internal.DirectoryConfigSource;
import io.helidon.config.internal.FileConfigSource;
import io.helidon.config.internal.MapConfigSource;
import io.helidon.config.internal.PrefixedConfigSource;
import io.helidon.config.internal.UrlConfigSource;
import io.helidon.config.spi.AbstractConfigSource;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ConfigSources {
    private static final String SOURCES_KEY = "sources";
    static final String DEFAULT_MAP_NAME = "map";
    static final String DEFAULT_PROPERTIES_NAME = "properties";

    private ConfigSources() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static ConfigSource empty() {
        return EmptyConfigSourceHolder.EMPTY;
    }

    public static ConfigSource create(Config config) {
        return ConfigSources.create(config.asMap().get()).get();
    }

    public static ConfigSource create(final ConfigNode.ObjectNode objectNode) {
        return new ConfigSource(){

            @Override
            public String description() {
                return "InMemoryConfig[ObjectNode]";
            }

            @Override
            public Optional<ConfigNode.ObjectNode> load() throws ConfigException {
                return Optional.of(objectNode);
            }
        };
    }

    public static ConfigSource create(Readable readable, String mediaType) {
        return ((InMemoryConfigSource.Builder)((InMemoryConfigSource.Builder)((InMemoryConfigSource.Builder)InMemoryConfigSource.builder().mediaType(mediaType)).changesExecutor(Runnable::run)).changesMaxBuffer(1)).content("Readable", ConfigParser.Content.create(readable, mediaType, Optional.of(Instant.now()))).build();
    }

    public static ConfigSource create(String content, String mediaType) {
        return ((InMemoryConfigSource.Builder)((InMemoryConfigSource.Builder)((InMemoryConfigSource.Builder)InMemoryConfigSource.builder().mediaType(mediaType)).changesExecutor(Runnable::run)).changesMaxBuffer(1)).content("String", ConfigParser.Content.create(new StringReader(content), mediaType, Optional.of(Instant.now()))).build();
    }

    public static MapBuilder create(Map<String, String> map) {
        return ConfigSources.create(map, DEFAULT_MAP_NAME);
    }

    public static MapBuilder create(Map<String, String> map, String name) {
        return new MapBuilder(map, name);
    }

    public static MapBuilder create(Properties properties) {
        return ConfigSources.create(properties, DEFAULT_PROPERTIES_NAME);
    }

    public static MapBuilder create(Properties properties, String name) {
        return new MapBuilder(properties, name);
    }

    public static ConfigSource prefixed(String key, Supplier<ConfigSource> sourceSupplier) {
        return new PrefixedConfigSource(key, sourceSupplier.get());
    }

    public static ConfigSource systemProperties() {
        return new SystemPropertiesConfigSource();
    }

    public static ConfigSource environmentVariables() {
        return new EnvironmentVariablesConfigSource();
    }

    public static AbstractParsableConfigSource.Builder<? extends AbstractParsableConfigSource.Builder<?, Path>, Path> classpath(String resource) {
        return new ClasspathConfigSource.ClasspathBuilder(resource);
    }

    public static AbstractParsableConfigSource.Builder<? extends AbstractParsableConfigSource.Builder<?, Path>, Path> file(String path) {
        return new FileConfigSource.FileBuilder(Paths.get(path, new String[0]));
    }

    public static AbstractConfigSource.Builder<? extends AbstractConfigSource.Builder<?, Path>, Path> directory(String path) {
        return new DirectoryConfigSource.DirectoryBuilder(Paths.get(path, new String[0]));
    }

    public static AbstractParsableConfigSource.Builder<? extends AbstractParsableConfigSource.Builder<?, URL>, URL> url(URL url) {
        return new UrlConfigSource.UrlBuilder(url);
    }

    @SafeVarargs
    public static CompositeBuilder create(Supplier<ConfigSource> ... configSources) {
        return ConfigSources.create(CollectionsHelper.listOf((Object[])configSources));
    }

    public static CompositeBuilder create(List<Supplier<ConfigSource>> configSources) {
        return new CompositeBuilder(configSources);
    }

    @SafeVarargs
    public static CompositeBuilder load(Supplier<ConfigSource> ... metaSources) {
        return ConfigSources.load(Config.builder(metaSources).disableEnvironmentVariablesSource().disableSystemPropertiesSource().build());
    }

    public static CompositeBuilder load(Config metaConfig) {
        List<Supplier<ConfigSource>> sources = metaConfig.get(SOURCES_KEY).asNodeList().orElse(CollectionsHelper.listOf()).stream().map(node -> node.as(ConfigSource::create)).map(ConfigValue::get).collect(Collectors.toList());
        return ConfigSources.create(sources);
    }

    static final class SystemPropertiesConfigSource
    extends MapConfigSource {
        SystemPropertiesConfigSource() {
            super(ConfigUtils.propertiesToMap(System.getProperties()), false, "");
        }
    }

    static final class EnvironmentVariablesConfigSource
    extends MapConfigSource {
        EnvironmentVariablesConfigSource() {
            super(EnvironmentVariables.expand(), false, "");
        }
    }

    private static final class EmptyConfigSourceHolder {
        private static final ConfigSource EMPTY = new ConfigSource(){

            @Override
            public String description() {
                return "Empty";
            }

            @Override
            public Optional<ConfigNode.ObjectNode> load() throws ConfigException {
                return Optional.empty();
            }
        };

        private EmptyConfigSourceHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static interface MergingStrategy {
        public ConfigNode.ObjectNode merge(List<ConfigNode.ObjectNode> var1);

        public static MergingStrategy fallback() {
            return new FallbackMergingStrategy();
        }
    }

    public static class CompositeBuilder
    implements Builder<ConfigSource> {
        private static final long DEFAULT_CHANGES_DEBOUNCE_TIMEOUT = 100L;
        private final List<ConfigSource> configSources;
        private MergingStrategy mergingStrategy;
        private ScheduledExecutorService changesExecutor;
        private int changesMaxBuffer;
        private Duration debounceTimeout;
        private volatile ConfigSource configSource;

        private CompositeBuilder(List<Supplier<ConfigSource>> configSources) {
            this.configSources = CompositeBuilder.initConfigSources(configSources);
            this.changesExecutor = CompositeConfigSource.DEFAULT_CHANGES_EXECUTOR_SERVICE;
            this.debounceTimeout = Duration.ofMillis(100L);
            this.changesMaxBuffer = Flow.defaultBufferSize();
        }

        private static List<ConfigSource> initConfigSources(List<Supplier<ConfigSource>> sourceSuppliers) {
            LinkedList<ConfigSource> configSources = new LinkedList<ConfigSource>();
            for (Supplier<ConfigSource> configSupplier : sourceSuppliers) {
                configSources.add(configSupplier.get());
            }
            return configSources;
        }

        public CompositeBuilder add(Supplier<ConfigSource> source) {
            Objects.requireNonNull(source, "source cannot be null");
            this.configSources.add(source.get());
            return this;
        }

        public CompositeBuilder mergingStrategy(MergingStrategy mergingStrategy) {
            Objects.requireNonNull(mergingStrategy, "mergingStrategy cannot be null");
            this.mergingStrategy = mergingStrategy;
            return this;
        }

        public CompositeBuilder changesExecutor(ScheduledExecutorService changesExecutor) {
            this.changesExecutor = changesExecutor;
            return this;
        }

        public CompositeBuilder changesDebounce(Duration debounceTimeout) {
            this.debounceTimeout = debounceTimeout;
            return this;
        }

        public CompositeBuilder changesMaxBuffer(int changesMaxBuffer) {
            this.changesMaxBuffer = changesMaxBuffer;
            return this;
        }

        public ConfigSource build() {
            LinkedList<ConfigSource> finalConfigSources = new LinkedList<ConfigSource>(this.configSources);
            MergingStrategy finalMergingStrategy = this.mergingStrategy != null ? this.mergingStrategy : new FallbackMergingStrategy();
            return this.createCompositeConfigSource(finalConfigSources, finalMergingStrategy, this.changesExecutor, this.debounceTimeout, this.changesMaxBuffer);
        }

        public ConfigSource get() {
            if (this.configSource == null) {
                this.configSource = this.build();
            }
            return this.configSource;
        }

        CompositeConfigSource createCompositeConfigSource(List<ConfigSource> finalConfigSources, MergingStrategy finalMergingStrategy, ScheduledExecutorService reloadExecutorService, Duration debounceTimeout, int changesMaxBuffer) {
            return new CompositeConfigSource(finalConfigSources, finalMergingStrategy, reloadExecutorService, debounceTimeout, changesMaxBuffer);
        }
    }

    public static final class MapBuilder
    implements Builder<ConfigSource> {
        private Map<String, String> map;
        private boolean strict;
        private String mapSourceName;
        private volatile ConfigSource configSource;

        private MapBuilder(Map<String, String> map, String name) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(map, "map cannot be null");
            this.map = Collections.unmodifiableMap(map);
            this.strict = true;
            this.mapSourceName = name;
        }

        private MapBuilder(Properties properties, String name) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(properties, "properties cannot be null");
            this.map = ConfigUtils.propertiesToMap(properties);
            this.strict = true;
            this.mapSourceName = name;
        }

        public MapBuilder lax() {
            this.strict = false;
            return this;
        }

        public ConfigSource build() {
            return new MapConfigSource(this.map, this.strict, this.mapSourceName);
        }

        public ConfigSource get() {
            if (this.configSource == null) {
                this.configSource = this.build();
            }
            return this.configSource;
        }
    }
}

