/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.RetryPolicyImpl;
import io.helidon.config.spi.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class RetryPolicies {
    private RetryPolicies() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static Builder repeat(int retries) {
        return new Builder(retries);
    }

    public static RetryPolicy justCall() {
        return JustCallRetryPolicyHolder.JUST_CALL;
    }

    public static final class Builder
    implements io.helidon.common.Builder<RetryPolicy> {
        private static final String RETRIES_KEY = "retries";
        private int retries;
        private Duration delay;
        private double delayFactor;
        private Duration callTimeout;
        private Duration overallTimeout;
        private ScheduledExecutorService executorService;

        private Builder(int retries) {
            this.retries = retries;
            this.delay = Duration.ofMillis(200L);
            this.delayFactor = 2.0;
            this.callTimeout = Duration.ofMillis(500L);
            this.overallTimeout = Duration.ofSeconds(2L);
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ConfigThreadFactory("retry-policy"));
        }

        public static Builder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
            Builder builder = new Builder(metaConfig.get(RETRIES_KEY).asInt().get());
            metaConfig.get("delay").as(Duration.class).ifPresent(builder::delay);
            metaConfig.get("delay-factor").asDouble().ifPresent(builder::delayFactor);
            metaConfig.get("call-timeout").as(Duration.class).ifPresent(builder::callTimeout);
            metaConfig.get("overall-timeout").as(Duration.class).ifPresent(builder::overallTimeout);
            return builder;
        }

        public Builder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Builder delayFactor(double delayFactor) {
            this.delayFactor = delayFactor;
            return this;
        }

        public Builder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder overallTimeout(Duration overallTimeout) {
            this.overallTimeout = overallTimeout;
            return this;
        }

        public Builder executor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RetryPolicy build() {
            return new RetryPolicyImpl(this.retries, this.delay, this.delayFactor, this.callTimeout, this.overallTimeout, this.executorService);
        }

        public RetryPolicy get() {
            return this.build();
        }
    }

    private static final class JustCallRetryPolicyHolder {
        private static final RetryPolicy JUST_CALL = new RetryPolicy(){

            @Override
            public <T> T execute(Supplier<T> call) {
                return call.get();
            }
        };

        private JustCallRetryPolicyHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }
}

