/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigNode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterators;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;

public final class ConfigUtils {
    private static final Logger LOGGER = Logger.getLogger(ConfigUtils.class.getName());

    private ConfigUtils() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static <S> Stream<S> asStream(Iterable<? extends S> items) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(items.iterator(), 16), false);
    }

    public static <S> Stream<S> asStream(Iterator<S> iterator) {
        return ConfigUtils.asStream(() -> iterator);
    }

    public static <S> Stream<? extends S> asPrioritizedStream(Iterable<? extends S> items, int defaultPriority) {
        return ConfigUtils.asStream(items).sorted(ConfigUtils.priorityComparator(defaultPriority));
    }

    public static <S> Comparator<S> priorityComparator(int defaultPriority) {
        return (service1, service2) -> {
            int service1Priority = Optional.ofNullable(service1.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(defaultPriority);
            int service2Priority = Optional.ofNullable(service2.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(defaultPriority);
            return service2Priority - service1Priority;
        };
    }

    public static ConfigNode.ObjectNode mapToObjectNode(Map<String, String> map, boolean strict) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                builder.addValue(entry.getKey(), entry.getValue());
            }
            catch (ConfigException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(Level.CONFIG, "Tree-structure failure on key '" + entry.getKey() + "', reason: " + ex.getLocalizedMessage());
                LOGGER.log(Level.FINEST, "Detailed reason of failure of adding key '" + entry.getKey() + "' = '" + entry.getValue() + "'.", ex);
            }
        }
        return builder.build();
    }

    public static Map<String, String> propertiesToMap(Properties properties) {
        return properties.stringPropertyNames().stream().collect(Collectors.toMap(k -> k, properties::getProperty));
    }

    public static void shutdownExecutor(ScheduledExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
    }

    static Charset getContentCharset(String contentEncoding) throws ConfigException {
        try {
            return Optional.ofNullable(contentEncoding).map(Charset::forName).orElse(StandardCharsets.UTF_8);
        }
        catch (UnsupportedCharsetException ex) {
            throw new ConfigException("Unsupported response content-encoding '" + contentEncoding + "'.", ex);
        }
    }

    public static final class EmptyObjectNodeHolder {
        public static final ConfigNode.ObjectNode EMPTY = ConfigNode.ObjectNode.builder().build();

        private EmptyObjectNodeHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static class ScheduledTask {
        private final ScheduledExecutorService executorService;
        private final Runnable command;
        private final Duration delay;
        private volatile ScheduledFuture<?> scheduled;
        private final Object lock = new Object();

        public ScheduledTask(ScheduledExecutorService executorService, Runnable command, Duration delay) {
            this.executorService = executorService;
            this.command = command;
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean schedule() {
            boolean result = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.scheduled != null && !this.scheduled.isCancelled() && !this.scheduled.isDone()) {
                    this.scheduled.cancel(false);
                    LOGGER.log(Level.FINER, String.format("Cancelling and rescheduling %s task.", this.command));
                    result = true;
                }
                this.scheduled = this.executorService.schedule(this.command, this.delay.toMillis(), TimeUnit.MILLISECONDS);
            }
            return result;
        }
    }
}

