/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.SubmissionPublisher;
import io.helidon.config.ConfigHelper;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.PollingStrategy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScheduledPollingStrategy
implements PollingStrategy {
    private static final Logger LOGGER = Logger.getLogger(ScheduledPollingStrategy.class.getName());
    private final RecurringPolicy recurringPolicy;
    private final SubmissionPublisher<PollingStrategy.PollingEvent> ticksSubmitter;
    private final Flow.Publisher<PollingStrategy.PollingEvent> ticksPublisher;
    private final boolean customExecutor;
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledExecutorService executor;

    public static ScheduledPollingStrategy create(RecurringPolicy recurringPolicy, ScheduledExecutorService executor) {
        return new ScheduledPollingStrategy(recurringPolicy, executor);
    }

    private ScheduledPollingStrategy(RecurringPolicy recurringPolicy, ScheduledExecutorService executor) {
        Objects.requireNonNull(recurringPolicy, "recurringPolicy cannot be null");
        this.recurringPolicy = recurringPolicy;
        if (executor == null) {
            this.customExecutor = false;
        } else {
            this.customExecutor = true;
            this.executor = executor;
        }
        this.ticksSubmitter = new SubmissionPublisher(Runnable::run, 1);
        this.ticksPublisher = ConfigHelper.suspendablePublisher(this.ticksSubmitter, this::startScheduling, this::stopScheduling);
    }

    @Override
    public Flow.Publisher<PollingStrategy.PollingEvent> ticks() {
        return this.ticksPublisher;
    }

    void configSourceChanged(boolean changed) {
        if (changed) {
            this.recurringPolicy.shorten();
        } else {
            this.recurringPolicy.lengthen();
        }
    }

    public RecurringPolicy recurringPolicy() {
        return this.recurringPolicy;
    }

    synchronized void startScheduling() {
        if (!this.customExecutor) {
            this.executor = Executors.newScheduledThreadPool(1, new ConfigThreadFactory("scheduled-polling"));
        }
        this.scheduleNext();
    }

    private void scheduleNext() {
        this.scheduledFuture = this.executor.schedule(this::fireEvent, this.recurringPolicy.interval().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void fireEvent() {
        this.ticksSubmitter.offer((Object)PollingStrategy.PollingEvent.now(), (subscriber, pollingEvent) -> {
            LOGGER.log(Level.FINER, String.format("Event %s has not been delivered to %s.", pollingEvent, subscriber));
            return false;
        });
        this.scheduleNext();
    }

    synchronized void stopScheduling() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (!this.customExecutor) {
            ConfigUtils.shutdownExecutor(this.executor);
            this.executor = null;
        }
    }

    ScheduledFuture<?> scheduledFuture() {
        return this.scheduledFuture;
    }

    ScheduledExecutorService executor() {
        return this.executor;
    }

    public String toString() {
        return "ScheduledPollingStrategy{recurringPolicy=" + this.recurringPolicy + '}';
    }

    @FunctionalInterface
    public static interface RecurringPolicy {
        public Duration interval();

        default public void shorten() {
        }

        default public void lengthen() {
        }

        public static AdaptiveBuilder adaptiveBuilder(Duration initialInterval) {
            return new AdaptiveBuilder(initialInterval);
        }

        public static final class AdaptiveBuilder {
            private Duration interval;
            private Duration min;
            private Duration max;
            private BiFunction<Duration, Integer, Duration> shortenFunction;
            private BiFunction<Duration, Integer, Duration> lengthenFunction;
            private static final BiFunction<Duration, Integer, Duration> DEFAULT_SHORTEN = (currentDuration, changesFactor) -> currentDuration.dividedBy(2L);
            private static final BiFunction<Duration, Integer, Duration> DEFAULT_LENGTHEN = (currentDuration, changesFactor) -> currentDuration.multipliedBy(2L);

            private AdaptiveBuilder(Duration initialInterval) {
                this.interval = initialInterval;
            }

            public AdaptiveBuilder min(Duration min) {
                this.min = min;
                return this;
            }

            public AdaptiveBuilder max(Duration max) {
                this.max = max;
                return this;
            }

            public AdaptiveBuilder shorten(BiFunction<Duration, Integer, Duration> shortenFunction) {
                this.shortenFunction = shortenFunction;
                return this;
            }

            public AdaptiveBuilder lengthen(BiFunction<Duration, Integer, Duration> lengthenFunction) {
                this.lengthenFunction = lengthenFunction;
                return this;
            }

            public RecurringPolicy build() {
                Duration min = this.min == null ? this.interval.dividedBy(10L) : this.min;
                Duration max = this.max == null ? this.interval.multipliedBy(5L) : this.max;
                BiFunction<Duration, Integer, Duration> lengthenFunction = this.lengthenFunction == null ? DEFAULT_LENGTHEN : this.lengthenFunction;
                BiFunction<Duration, Integer, Duration> shortenFunction = this.shortenFunction == null ? DEFAULT_SHORTEN : this.shortenFunction;
                return new AdaptiveRecurringPolicy(min, this.interval, max, shortenFunction, lengthenFunction);
            }
        }
    }

    static class AdaptiveRecurringPolicy
    implements RecurringPolicy {
        private final Duration min;
        private final Duration max;
        private final BiFunction<Duration, Integer, Duration> shortenFunction;
        private final BiFunction<Duration, Integer, Duration> lengthenFunction;
        private Duration delay;
        private AtomicInteger prolongationFactor = new AtomicInteger(0);

        AdaptiveRecurringPolicy(Duration min, Duration initialDelay, Duration max, BiFunction<Duration, Integer, Duration> shortenFunction, BiFunction<Duration, Integer, Duration> lengthenFunction) {
            this.min = min;
            this.max = max;
            this.delay = initialDelay;
            this.shortenFunction = shortenFunction;
            this.lengthenFunction = lengthenFunction;
        }

        @Override
        public Duration interval() {
            return this.delay;
        }

        @Override
        public void shorten() {
            int factor = this.prolongationFactor.updateAndGet(i -> {
                if (i < 0) {
                    return --i;
                }
                return -1;
            });
            Duration candidate = this.shortenFunction.apply(this.delay, -factor);
            this.delay = this.min.compareTo(candidate) > 0 ? this.min : candidate;
        }

        @Override
        public void lengthen() {
            int factor = this.prolongationFactor.updateAndGet(i -> {
                if (i > 0) {
                    return ++i;
                }
                return 1;
            });
            Duration candidate = this.lengthenFunction.apply(this.delay, factor);
            this.delay = this.max.compareTo(candidate) > 0 ? candidate : this.max;
        }

        Duration delay() {
            return this.delay;
        }
    }

    public static class RegularRecurringPolicy
    implements RecurringPolicy {
        private final Duration interval;

        public RegularRecurringPolicy(Duration interval) {
            this.interval = interval;
        }

        @Override
        public Duration interval() {
            return this.interval;
        }

        public String toString() {
            return "RegularRecurringPolicy{interval=" + this.interval + '}';
        }
    }
}

