/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigExistingImpl;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class ConfigLeafImpl
extends ConfigExistingImpl<ConfigNode.ValueNode> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private final ConfigMapperManager mapperManager;

    ConfigLeafImpl(ConfigKeyImpl prefix, ConfigKeyImpl key, ConfigNode.ValueNode valueNode, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(Config.Type.VALUE, prefix, key, valueNode, filter, factory, mapperManager);
        this.mapperManager = mapperManager;
        Objects.requireNonNull(filter, "filter argument is null.");
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
        if (Config.class.equals(type)) {
            throw new ConfigMappingException(this.key(), "The Config node represents single value.");
        }
        Optional<String> value = this.value();
        if (!value.isPresent()) {
            return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.asList(type));
        }
        String stringValue = value.get();
        if (stringValue.contains(",")) {
            return ConfigValues.create((Config)this, () -> {
                String[] parts = ConfigLeafImpl.toArray(stringValue);
                LinkedList result = new LinkedList();
                for (String part : parts) {
                    result.add(this.mapperManager.map(part, type, this.name()));
                }
                return Optional.of(result);
            }, (Config aConfig) -> aConfig.asList(type));
        }
        return ConfigValues.create((Config)this, () -> Optional.of(CollectionsHelper.listOf((Object[])new Object[]{this.mapperManager.map(stringValue, type, this.name())})), (Config aConfig) -> aConfig.asList(type));
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
        Optional<String> value = this.value();
        if (!value.isPresent()) {
            return ConfigValues.create((Config)this, Optional::empty, (Config aConfig) -> aConfig.asList(mapper));
        }
        String stringValue = value.get();
        if (stringValue.contains(",")) {
            return ConfigValues.create((Config)this, () -> {
                String[] parts = ConfigLeafImpl.toArray(stringValue);
                LinkedList result = new LinkedList();
                for (String part : parts) {
                    result.add(mapper.apply(this.mapperManager.simpleConfig(this.name(), part)));
                }
                return Optional.of(result);
            }, (Config aConfig) -> aConfig.asList(mapper));
        }
        return ConfigValues.create((Config)this, () -> Optional.of(CollectionsHelper.listOf((Object[])new Object[]{mapper.apply(this.mapperManager.simpleConfig(this.name(), stringValue))})), (Config aConfig) -> aConfig.asList(mapper));
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = ESCAPED_COMMA_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(","));
        }
        return values;
    }

    @Override
    public Stream<Config> traverse(Predicate<Config> predicate) {
        return Stream.empty();
    }

    public String toString() {
        return "[" + this.realKey() + "] VALUE '" + (String)((ConfigNode.ValueNode)this.node()).get() + "'";
    }
}

