/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

class UseFirstAvailableConfigSource
implements ConfigSource {
    private final List<? extends ConfigSource> configSources;
    private ConfigSource usedConfigSource;
    private String description;
    private Flow.Publisher<Optional<ConfigNode.ObjectNode>> changesPublisher;

    UseFirstAvailableConfigSource(List<? extends ConfigSource> configSources) {
        this.configSources = configSources;
        this.changesPublisher = Flow.Subscriber::onComplete;
        this.formatDescription(false);
    }

    UseFirstAvailableConfigSource(ConfigSource ... configSources) {
        this(Arrays.asList(configSources));
    }

    @Override
    public void init(ConfigContext context) {
        this.configSources.forEach(source -> source.init(context));
    }

    @Override
    public Optional<ConfigNode.ObjectNode> load() {
        Optional<ConfigNode.ObjectNode> result = Optional.empty();
        for (ConfigSource configSource : this.configSources) {
            result = configSource.load();
            if (!result.isPresent()) continue;
            this.usedConfigSource = configSource;
            this.changesPublisher = this.usedConfigSource.changes();
            break;
        }
        this.formatDescription(true);
        return result;
    }

    private void formatDescription(boolean loaded) {
        StringBuilder descriptionSB = new StringBuilder();
        boolean availableFormatted = false;
        for (ConfigSource configSource : this.configSources) {
            if (descriptionSB.length() > 0) {
                descriptionSB.append("->");
            }
            if (loaded) {
                if (configSource == this.usedConfigSource) {
                    availableFormatted = true;
                    descriptionSB.append("*").append(configSource.description()).append("*");
                    continue;
                }
                if (availableFormatted) {
                    descriptionSB.append("/").append(configSource.description()).append("/");
                    continue;
                }
                descriptionSB.append("(").append(configSource.description()).append(")");
                continue;
            }
            descriptionSB.append(configSource.description());
        }
        this.description = descriptionSB.toString();
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Flow.Publisher<Optional<ConfigNode.ObjectNode>> changes() {
        return this.changesPublisher;
    }
}

