/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigSources;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ClasspathConfigSource;
import io.helidon.config.internal.DirectoryConfigSource;
import io.helidon.config.internal.FileConfigSource;
import io.helidon.config.internal.UrlConfigSource;
import io.helidon.config.spi.ConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

class ConfigSourceConfigMapper
implements Function<Config, ConfigSource> {
    private static final String META_CONFIG_SOURCES_PROPERTIES = "META-INF/resources/meta-config-sources.properties";
    private static final String PROPERTIES_KEY = "properties";
    private static final String TYPE_KEY = "type";
    private static final String CLASS_KEY = "class";
    private static final String KEY_KEY = "key";
    private static final String SYSTEM_PROPERTIES_TYPE = "system-properties";
    private static final String ENVIRONMENT_VARIABLES_TYPE = "environment-variables";
    private static final String PREFIXED_TYPE = "prefixed";
    private static final String CLASSPATH_TYPE = "classpath";
    private static final String FILE_TYPE = "file";
    private static final String DIRECTORY_TYPE = "directory";
    private static final String URL_TYPE = "url";
    private final Map<String, String> customSources = ConfigSourceConfigMapper.initCustomSources();

    ConfigSourceConfigMapper() {
    }

    private static Map<String, String> initCustomSources() {
        try {
            Properties properties = new Properties();
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(META_CONFIG_SOURCES_PROPERTIES);
            while (e.hasMoreElements()) {
                URL resource = e.nextElement();
                InputStream is = resource.openStream();
                try {
                    properties.load(is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            HashMap<String, String> providers = new HashMap<String, String>();
            for (String type : properties.stringPropertyNames()) {
                providers.put(type, properties.getProperty(type));
            }
            return providers;
        }
        catch (IOException ex) {
            throw new ConfigException("Loading of META-INF/resources/meta-config-sources.properties resources has failed with exception.", ex);
        }
    }

    static ConfigSourceConfigMapper instance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public ConfigSource apply(Config config) throws ConfigMappingException, MissingValueException {
        Config properties = config.get(PROPERTIES_KEY).asNode().orElse(Config.empty(config));
        return (ConfigSource)OptionalHelper.from(config.get(TYPE_KEY).asString().flatMap(type -> OptionalHelper.from(this.builtin((String)type, properties)).or(() -> this.providers((String)type, properties)).asOptional())).or(() -> config.get(CLASS_KEY).as(Class.class).flatMap(clazz -> this.custom((Class<?>)clazz, properties))).asOptional().orElseThrow(() -> new ConfigMappingException(config.key(), "Uncompleted source configuration."));
    }

    private Optional<ConfigSource> builtin(String type, Config properties) {
        ConfigSource configSource;
        switch (type) {
            case "system-properties": {
                configSource = ConfigSources.systemProperties();
                break;
            }
            case "environment-variables": {
                configSource = ConfigSources.environmentVariables();
                break;
            }
            case "prefixed": {
                configSource = ConfigSources.prefixed(properties.get(KEY_KEY).asString().orElse(""), properties.as(ConfigSource::create).get());
                break;
            }
            case "classpath": {
                configSource = properties.as(ClasspathConfigSource::create).get();
                break;
            }
            case "file": {
                configSource = properties.as(FileConfigSource::create).get();
                break;
            }
            case "directory": {
                configSource = properties.as(DirectoryConfigSource::create).get();
                break;
            }
            case "url": {
                configSource = properties.as(UrlConfigSource::create).get();
                break;
            }
            default: {
                configSource = null;
            }
        }
        return Optional.ofNullable(configSource);
    }

    private Optional<ConfigSource> providers(String type, Config properties) {
        return Optional.ofNullable(this.customSources.get(type)).map(ConfigMappers::toClass).flatMap(clazz -> this.custom((Class<?>)clazz, properties));
    }

    private Optional<ConfigSource> custom(Class<?> clazz, Config properties) {
        Object source = properties.as(clazz).get();
        if (source instanceof ConfigSource) {
            return Optional.of((ConfigSource)source);
        }
        throw new ConfigException("Failed to process configuration metadata, configured class " + clazz.getName() + " does not implement ConfigSource");
    }

    static final class SingletonHolder {
        private static final ConfigSourceConfigMapper INSTANCE = new ConfigSourceConfigMapper();

        private SingletonHolder() {
        }
    }
}

