/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.PollingStrategies;
import io.helidon.config.spi.PollingStrategy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class PollingStrategyConfigMapper {
    private static final Logger LOGGER = Logger.getLogger(PollingStrategyConfigMapper.class.getName());
    private static final String PROPERTIES_KEY = "properties";
    private static final String TYPE_KEY = "type";
    private static final String CLASS_KEY = "class";
    private static final String REGULAR_TYPE = "regular";
    private static final String WATCH_TYPE = "watch";

    PollingStrategyConfigMapper() {
    }

    static PollingStrategyConfigMapper instance() {
        return SingletonHolder.INSTANCE;
    }

    public <T> Function<T, Supplier<PollingStrategy>> apply(Config config, Class<T> targetType) throws ConfigMappingException, MissingValueException {
        Config properties = config.get(PROPERTIES_KEY).asNode().orElse(Config.empty(config));
        return (Function)OptionalHelper.from(config.get(TYPE_KEY).asString().flatMap(type -> this.builtin((String)type, properties, targetType))).or(() -> config.get(CLASS_KEY).as(Class.class).flatMap(clazz -> this.custom((Class<?>)clazz, properties, targetType))).asOptional().orElseThrow(() -> new ConfigMappingException(config.key(), "Uncompleted polling-strategy configuration."));
    }

    private <T> Optional<Function<T, Supplier<PollingStrategy>>> builtin(String type, Config properties, Class<T> targetType) {
        Function<Object, Supplier> pollingStrategy;
        switch (type) {
            case "regular": {
                pollingStrategy = target -> (Supplier)((Object)properties.as(PollingStrategies.ScheduledBuilder.class).get());
                break;
            }
            case "watch": {
                pollingStrategy = PollingStrategyConfigMapper::watchSupplier;
                break;
            }
            default: {
                pollingStrategy = null;
            }
        }
        return Optional.ofNullable(pollingStrategy);
    }

    private static <T> Supplier<PollingStrategy> watchSupplier(T target) {
        if (target instanceof Path) {
            Path path = (Path)target;
            return PollingStrategies.watch(path);
        }
        throw new ConfigException("Incorrect target type ('" + target.getClass().getName() + "') for WATCH polling strategy. Expected 'Path'.");
    }

    private <T> Optional<Function<T, Supplier<PollingStrategy>>> custom(Class<?> clazz, Config properties, Class<T> targetType) {
        Function<Object, Supplier<Object>> pollingStrategyFunction;
        if (PollingStrategy.class.isAssignableFrom(clazz)) {
            try {
                Constructor<?> constructor = clazz.getConstructor(targetType);
                MethodHandle constructorHandle = MethodHandles.publicLookup().unreflectConstructor(constructor);
                pollingStrategyFunction = PollingStrategyConfigMapper.customSupplier(constructorHandle);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                LOGGER.log(Level.FINE, ex, () -> clazz.getName() + " does not have public constructor with single parameter (" + targetType.getName() + "). Generic instance from Config will be used.");
                pollingStrategyFunction = target -> (Supplier)properties.as(clazz).get();
            }
        } else {
            throw new ConfigException("Configured polling strategy class " + clazz.getName() + " does not implement PollingStrategy");
        }
        return Optional.ofNullable(pollingStrategyFunction);
    }

    private static <T> Function<T, Supplier<PollingStrategy>> customSupplier(MethodHandle constructorHandle) {
        return target -> {
            try {
                return constructorHandle.invoke(target);
            }
            catch (Throwable ex) {
                throw new ConfigException("Creating new polling strategy instance has failed with exception.", ex);
            }
        };
    }

    static class SingletonHolder {
        private static final PollingStrategyConfigMapper INSTANCE = new PollingStrategyConfigMapper();

        SingletonHolder() {
        }
    }
}

