/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigDiff;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.internal.ConfigKeyImpl;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractConfigImpl
implements Config {
    public static final Logger LOGGER = Logger.getLogger(AbstractConfigImpl.class.getName());
    private final ConfigKeyImpl prefix;
    private final ConfigKeyImpl key;
    private final ConfigKeyImpl realKey;
    private final ConfigFactory factory;
    private final Config.Type type;
    private final Flow.Publisher<Config> changesPublisher;
    private final Config.Context context;
    private final ConfigMapperManager mapperManager;
    private volatile Flow.Subscriber<ConfigDiff> subscriber;
    private final ReentrantReadWriteLock subscriberLock = new ReentrantReadWriteLock();

    AbstractConfigImpl(Config.Type type, ConfigKeyImpl prefix, ConfigKeyImpl key, ConfigFactory factory, ConfigMapperManager mapperManager) {
        this.mapperManager = mapperManager;
        Objects.requireNonNull(prefix, "prefix argument is null.");
        Objects.requireNonNull(key, "key argument is null.");
        Objects.requireNonNull(factory, "factory argument is null.");
        this.prefix = prefix;
        this.key = key;
        this.realKey = prefix.child(key);
        this.factory = factory;
        this.type = type;
        this.changesPublisher = new FilteringConfigChangeEventPublisher(factory.changes());
        this.context = new NodeContextImpl();
    }

    ConfigMapperManager mapperManager() {
        return this.mapperManager;
    }

    Optional<String> value() {
        return Optional.empty();
    }

    @Override
    public Config.Context context() {
        return this.context;
    }

    @Override
    public final Instant timestamp() {
        return this.factory.timestamp();
    }

    @Override
    public final ConfigKeyImpl key() {
        return this.key;
    }

    protected final ConfigKeyImpl realKey() {
        return this.realKey;
    }

    @Override
    public final Config.Type type() {
        return this.type;
    }

    @Override
    public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
        return this.mapperManager.map(value, type, "");
    }

    @Override
    public final Config get(Config.Key subKey) {
        Objects.requireNonNull(subKey, "Key argument is null.");
        if (subKey.isRoot()) {
            return this;
        }
        return this.factory.config(this.prefix, this.key.child(subKey));
    }

    @Override
    public final Config detach() {
        if (this.key.isRoot()) {
            return this;
        }
        return this.factory.config(this.realKey(), ConfigKeyImpl.of());
    }

    @Override
    public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
        return this.asList(Config.class);
    }

    void subscribe() {
        block10: {
            try {
                this.subscriberLock.readLock().lock();
                if (this.subscriber != null) break block10;
                this.subscriberLock.readLock().unlock();
                this.subscriberLock.writeLock().lock();
                try {
                    try {
                        if (this.subscriber == null) {
                            this.waitForSubscription(1L, TimeUnit.SECONDS);
                        }
                    }
                    finally {
                        this.subscriberLock.readLock().lock();
                    }
                }
                finally {
                    this.subscriberLock.writeLock().unlock();
                }
            }
            finally {
                this.subscriberLock.readLock().unlock();
            }
        }
    }

    private void waitForSubscription(long timeout, TimeUnit unit) {
        final CountDownLatch subscribeLatch = new CountDownLatch(1);
        this.subscriber = new Flow.Subscriber<ConfigDiff>(){

            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
                subscribeLatch.countDown();
            }

            public void onNext(ConfigDiff item) {
            }

            public void onError(Throwable throwable) {
                LOGGER.log(Level.CONFIG, "Error while subscribing a supplier to the changes.", throwable);
            }

            public void onComplete() {
                LOGGER.log(Level.CONFIG, "The config suppliers will no longer receive any change.");
            }
        };
        this.factory.provider().changes().subscribe(this.subscriber);
        try {
            subscribeLatch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.CONFIG, "Waiting for a supplier subscription has been interrupted.", e);
            Thread.currentThread().interrupt();
        }
    }

    private Config contextConfig(Config rootConfig) {
        return rootConfig.get(this.prefix).detach().get(this.key);
    }

    ConfigFactory factory() {
        return this.factory;
    }

    @Override
    public Flow.Publisher<Config> changes() {
        return this.changesPublisher;
    }

    private class NodeContextImpl
    implements Config.Context {
        private NodeContextImpl() {
        }

        @Override
        public Instant timestamp() {
            return AbstractConfigImpl.this.factory.context().timestamp();
        }

        @Override
        public Config last() {
            AbstractConfigImpl.this.subscribe();
            return AbstractConfigImpl.this.contextConfig(AbstractConfigImpl.this.factory.context().last());
        }

        @Override
        public Config reload() {
            return AbstractConfigImpl.this.contextConfig(AbstractConfigImpl.this.factory.context().reload());
        }
    }

    private class FilteringConfigChangeEventSubscriber
    implements Flow.Subscriber<ConfigDiff> {
        private final Flow.Subscriber<? super Config> delegate;
        private Flow.Subscription subscription;

        private FilteringConfigChangeEventSubscriber(Flow.Subscriber<? super Config> delegate) {
            this.delegate = delegate;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.delegate.onSubscribe(subscription);
        }

        public void onNext(ConfigDiff event) {
            if (event.changedKeys().contains(AbstractConfigImpl.this.realKey)) {
                this.delegate.onNext((Object)AbstractConfigImpl.this.contextConfig(event.config()));
            } else {
                this.subscription.request(1L);
            }
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    private class FilteringConfigChangeEventPublisher
    implements Flow.Publisher<Config> {
        private Flow.Publisher<ConfigDiff> delegate;

        private FilteringConfigChangeEventPublisher(Flow.Publisher<ConfigDiff> delegate) {
            this.delegate = delegate;
        }

        public void subscribe(Flow.Subscriber<? super Config> subscriber) {
            this.delegate.subscribe((Flow.Subscriber)new FilteringConfigChangeEventSubscriber(subscriber));
        }
    }
}

