/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.GenericType;
import io.helidon.common.reactive.Flow;
import io.helidon.config.BuilderImpl;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigSources;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.MissingValueException;
import io.helidon.config.OverrideSources;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Config {
    public static Config empty() {
        return BuilderImpl.EmptyConfigHolder.EMPTY;
    }

    public static Config empty(Config config) {
        return new BuilderImpl().sources(ConfigSources.empty()).overrides(OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableMapperServices().disableParserServices().disableFilterServices().mappersFrom(config).build();
    }

    public static Config create() {
        return Config.builder().build();
    }

    @SafeVarargs
    public static Config create(Supplier<ConfigSource> ... configSources) {
        return Config.builder(configSources).build();
    }

    @SafeVarargs
    public static Config loadSourcesFrom(Supplier<ConfigSource> ... metaSources) {
        return Config.builderLoadSourcesFrom(metaSources).build();
    }

    @SafeVarargs
    public static Builder builder(Supplier<ConfigSource> ... configSources) {
        return Config.builder().sources(CollectionsHelper.listOf((Object[])configSources));
    }

    @SafeVarargs
    public static Builder builderLoadSourcesFrom(Supplier<ConfigSource> ... metaSources) {
        return Config.builder(new Supplier[]{ConfigSources.load(metaSources)}).disableSystemPropertiesSource().disableEnvironmentVariablesSource();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    default public Context context() {
        return new Context(){

            @Override
            public Instant timestamp() {
                return Config.this.timestamp();
            }

            @Override
            public Config last() {
                return Config.this;
            }

            @Override
            public Config reload() {
                return Config.this;
            }
        };
    }

    public Instant timestamp();

    public Key key();

    default public String name() {
        return this.key().name();
    }

    default public Config get(String key) {
        Objects.requireNonNull(key, "Key argument is null.");
        return this.get(ConfigKeyImpl.of(key));
    }

    public Config get(Key var1);

    public Config detach();

    public Type type();

    default public boolean exists() {
        return this.type().exists();
    }

    default public boolean isLeaf() {
        return this.type().isLeaf();
    }

    public boolean hasValue();

    default public void ifExists(Consumer<Config> action) {
        this.asNode().ifPresent(action);
    }

    default public Stream<Config> traverse() {
        return this.traverse(node -> true);
    }

    public Stream<Config> traverse(Predicate<Config> var1);

    public <T> T convert(Class<T> var1, String var2) throws ConfigMappingException;

    public <T> ConfigValue<T> as(GenericType<T> var1);

    public <T> ConfigValue<T> as(Class<T> var1);

    public <T> ConfigValue<T> as(Function<Config, T> var1);

    default public ConfigValue<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    default public ConfigValue<String> asString() {
        return this.as(String.class);
    }

    default public ConfigValue<Integer> asInt() {
        return this.as(Integer.class);
    }

    default public ConfigValue<Long> asLong() {
        return this.as(Long.class);
    }

    default public ConfigValue<Double> asDouble() {
        return this.as(Double.class);
    }

    public <T> ConfigValue<List<T>> asList(Class<T> var1) throws ConfigMappingException;

    public <T> ConfigValue<List<T>> asList(Function<Config, T> var1) throws ConfigMappingException;

    default public ConfigValue<Config> asNode() {
        return ConfigValues.create(this, () -> this.exists() ? Optional.of(this) : Optional.empty(), Config::asNode);
    }

    public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException;

    public ConfigValue<Map<String, String>> asMap() throws MissingValueException;

    @Deprecated
    default public Flow.Publisher<Config> changes() {
        return Flow.Subscriber::onComplete;
    }

    @Deprecated
    default public void onChange(Function<Config, Boolean> onNextFunction) {
        this.changes().subscribe(ConfigHelper.subscriber(onNextFunction));
    }

    default public void onChange(Consumer<Config> onChangeConsumer) {
        this.changes().subscribe(ConfigHelper.subscriber(config -> {
            onChangeConsumer.accept((Config)config);
            return true;
        }));
    }

    public static interface Builder {
        public Builder sources(List<Supplier<ConfigSource>> var1);

        default public Builder sources(Supplier<ConfigSource> configSource) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource}));
            return this;
        }

        default public Builder sources(Supplier<ConfigSource> configSource, Supplier<ConfigSource> configSource2) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource, configSource2}));
            return this;
        }

        default public Builder sources(Supplier<ConfigSource> configSource, Supplier<ConfigSource> configSource2, Supplier<ConfigSource> configSource3) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource, configSource2, configSource3}));
            return this;
        }

        public Builder overrides(Supplier<OverrideSource> var1);

        public Builder disableKeyResolving();

        public Builder disableValueResolving();

        public Builder disableEnvironmentVariablesSource();

        public Builder disableSystemPropertiesSource();

        public <T> Builder addMapper(Class<T> var1, Function<Config, T> var2);

        public <T> Builder addMapper(GenericType<T> var1, Function<Config, T> var2);

        public <T> Builder addStringMapper(Class<T> var1, Function<String, T> var2);

        public Builder addMapper(ConfigMapperProvider var1);

        public Builder disableMapperServices();

        public Builder addParser(ConfigParser var1);

        public Builder disableParserServices();

        public Builder addFilter(ConfigFilter var1);

        public Builder addFilter(Function<Config, ConfigFilter> var1);

        public Builder addFilter(Supplier<Function<Config, ConfigFilter>> var1);

        public Builder disableFilterServices();

        public Builder disableCaching();

        public Builder changesExecutor(Executor var1);

        public Builder changesMaxBuffer(int var1);

        public Config build();

        public Builder mappersFrom(Config var1);
    }

    public static interface Context {
        public Instant timestamp();

        public Config last();

        public Config reload();
    }

    public static enum Type {
        OBJECT(true, false),
        LIST(true, false),
        VALUE(true, true),
        MISSING(false, false);

        private boolean exists;
        private boolean isLeaf;

        private Type(boolean exists, boolean isLeaf) {
            this.exists = exists;
            this.isLeaf = isLeaf;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    public static interface Key
    extends Comparable<Key> {
        public Key parent();

        default public boolean isRoot() {
            return this.parent() == null;
        }

        public String name();

        public String toString();

        public Key child(Key var1);

        public static Key create(String key) {
            return ConfigKeyImpl.of(key);
        }

        public static String escapeName(String name) {
            if (!name.contains("~") && !name.contains(".")) {
                return name;
            }
            StringBuilder sb = new StringBuilder();
            char[] chars = name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch == '~') {
                    sb.append("~0");
                    continue;
                }
                if (ch == '.') {
                    sb.append("~1");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String unescapeName(String escapedName) {
            return escapedName.replaceAll("~1", ".").replaceAll("~0", "~");
        }
    }
}

