/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ConfigThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ClassLoader ccl;
    private final boolean daemon;

    ConfigThreadFactory(String type) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "config-" + POOL_NUMBER.getAndIncrement() + ":" + type + "-";
        this.ccl = Thread.currentThread().getContextClassLoader();
        this.daemon = true;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setContextClassLoader(this.ccl);
        t.setDaemon(this.daemon);
        return t;
    }
}

