/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OverrideSource;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class InMemoryOverrideSource
implements OverrideSource {
    private final OverrideSource.OverrideData overrideData;

    private InMemoryOverrideSource(Builder builder) {
        this.overrideData = builder.overrideData;
    }

    static Builder builder(Map<String, String> overrideValues) {
        return new Builder(overrideValues.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public Optional<ConfigContent.OverrideContent> load() throws ConfigException {
        return Optional.of(ConfigContent.OverrideContent.builder().data(this.overrideData).build());
    }

    public static final class Builder
    implements io.helidon.common.Builder<InMemoryOverrideSource> {
        private OverrideSource.OverrideData overrideData;
        private List<Map.Entry<String, String>> overrideWildcards;

        Builder(List<Map.Entry<String, String>> overrideWildcards) {
            Objects.requireNonNull(overrideWildcards, "overrideValues cannot be null");
            this.overrideWildcards = overrideWildcards;
        }

        public InMemoryOverrideSource build() {
            if (this.overrideWildcards.isEmpty()) {
                throw new ConfigException("Override values cannot be empty.");
            }
            this.overrideData = OverrideSource.OverrideData.createFromWildcards(this.overrideWildcards);
            return new InMemoryOverrideSource(this);
        }
    }
}

