/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.spi.ConfigSource;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class MetaConfigFinder {
    public static final String META_CONFIG_SYSTEM_PROPERTY = "io.helidon.config.meta-config";
    private static final Logger LOGGER = Logger.getLogger(MetaConfigFinder.class.getName());
    private static final List<String> CONFIG_SUFFIXES = List.of("yaml", "conf", "json", "properties");
    private static final String META_CONFIG_PREFIX = "meta-config.";
    private static final String CONFIG_PREFIX = "application.";
    private static final Set<String> FILES_LOGGED = new HashSet<String>();
    private static final Set<String> CLASSPATH_LOGGED = new HashSet<String>();

    private MetaConfigFinder() {
    }

    static Optional<Config> findMetaConfig(Function<String, Boolean> supportedMediaType) {
        return MetaConfigFinder.findMetaConfigSource(supportedMediaType).map(source -> Config.builder(source).build());
    }

    static Optional<ConfigSource> findConfigSource(Function<String, Boolean> supportedMediaType) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return MetaConfigFinder.findSource(supportedMediaType, cl, CONFIG_PREFIX, "config source");
    }

    private static Optional<ConfigSource> findMetaConfigSource(Function<String, Boolean> supportedMediaType) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String property = System.getProperty(META_CONFIG_SYSTEM_PROPERTY);
        if (null != property) {
            Optional<ConfigSource> source = MetaConfigFinder.findFile(property, "meta configuration");
            if (source.isPresent()) {
                return source;
            }
            source = MetaConfigFinder.findClasspath(cl, property, "meta configuration");
            if (source.isPresent()) {
                return source;
            }
            LOGGER.info("Meta configuration file not found: " + property);
        }
        return MetaConfigFinder.findSource(supportedMediaType, cl, META_CONFIG_PREFIX, "meta configuration");
    }

    private static Optional<ConfigSource> findSource(Function<String, Boolean> supportedMediaType, ClassLoader cl, String configPrefix, String type) {
        HashSet<String> invalidSuffixes = new HashSet<String>(CONFIG_SUFFIXES);
        List<String> validSuffixes = CONFIG_SUFFIXES.stream().filter(suffix -> (Boolean)supportedMediaType.apply(MediaTypes.detectExtensionType((String)suffix).orElse("unknown/unknown"))).collect(Collectors.toList());
        validSuffixes.forEach(invalidSuffixes::remove);
        Optional<ConfigSource> source = validSuffixes.stream().map(suf -> configPrefix + suf).map(it -> MetaConfigFinder.findFile(it, type)).flatMap(Optional::stream).findFirst();
        if (source.isPresent()) {
            return source;
        }
        source = validSuffixes.stream().map(suf -> configPrefix + suf).map(resource -> MetaConfigFinder.findClasspath(cl, resource, type)).flatMap(Optional::stream).findFirst();
        if (source.isPresent()) {
            return source;
        }
        invalidSuffixes.stream().map(suf -> configPrefix + suf).forEach(it -> {
            Optional<ConfigSource> found = MetaConfigFinder.findFile(it, type);
            if (found.isPresent() && FILES_LOGGED.add((String)it)) {
                LOGGER.warning("Configuration file " + it + " is on file system, yet there is no parser configured for it");
            }
            if ((found = MetaConfigFinder.findClasspath(cl, it, type)).isPresent() && CLASSPATH_LOGGED.add((String)it)) {
                LOGGER.warning("Configuration file " + it + " is on classpath, yet there is no parser configured for it");
            }
        });
        return Optional.empty();
    }

    private static Optional<ConfigSource> findFile(String name, String type) {
        Path path = Paths.get(name, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && !Files.isDirectory(path, new LinkOption[0])) {
            LOGGER.info("Found " + type + " file: " + path.toAbsolutePath());
            return Optional.of(ConfigSources.file(path).build());
        }
        return Optional.empty();
    }

    private static Optional<ConfigSource> findClasspath(ClassLoader cl, String name, String type) {
        URL resource = cl.getResource(name);
        if (null != resource) {
            LOGGER.fine(() -> "Found " + type + " resource: " + resource.getPath());
            return Optional.of(ConfigSources.classpath(name).build());
        }
        return Optional.empty();
    }
}

