/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.MetaConfigFinder;
import io.helidon.config.MetaProviders;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.RetryPolicy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Logger;

public final class MetaConfig {
    private static final Logger LOGGER = Logger.getLogger(MetaConfig.class.getName());

    private MetaConfig() {
    }

    public static Config config() {
        return MetaConfig.metaConfig().map(MetaConfig::config).orElseGet(MetaConfig::createDefault);
    }

    public static Config config(Config metaConfig) {
        return Config.builder().config(metaConfig).build();
    }

    public static Optional<Config> metaConfig() {
        return MetaConfigFinder.findMetaConfig(MetaConfig.supportedMediaTypes());
    }

    public static PollingStrategy pollingStrategy(Config metaConfig) {
        return MetaProviders.pollingStrategy(metaConfig.get("type").asString().get(), metaConfig.get("properties"));
    }

    public static ChangeWatcher<?> changeWatcher(Config metaConfig) {
        String type = metaConfig.get("type").asString().get();
        ChangeWatcher<?> changeWatcher = MetaProviders.changeWatcher(type, metaConfig.get("properties"));
        LOGGER.fine(() -> "Loaded change watcher of type \"" + type + "\", class: " + changeWatcher.getClass().getName());
        return changeWatcher;
    }

    public static RetryPolicy retryPolicy(Config metaConfig) {
        String type = metaConfig.get("type").asString().get();
        RetryPolicy retryPolicy = MetaProviders.retryPolicy(type, metaConfig.get("properties"));
        LOGGER.fine(() -> "Loaded retry policy of type \"" + type + "\", class: " + retryPolicy.getClass().getName());
        return retryPolicy;
    }

    public static List<ConfigSource> configSource(Config sourceMetaConfig) {
        String type = sourceMetaConfig.get("type").asString().get();
        boolean multiSource = sourceMetaConfig.get("multi-source").asBoolean().orElse(false);
        Config sourceProperties = sourceMetaConfig.get("properties");
        if (multiSource) {
            List<ConfigSource> sources = MetaProviders.configSources(type, sourceProperties);
            LOGGER.fine(() -> "Loaded sources of type \"" + type + "\", values: " + sources);
            return sources;
        }
        ConfigSource source = MetaProviders.configSource(type, sourceProperties);
        LOGGER.fine(() -> "Loaded source of type \"" + type + "\", class: " + source.getClass().getName());
        return List.of(source);
    }

    static OverrideSource overrideSource(Config sourceMetaConfig) {
        String type = sourceMetaConfig.get("type").asString().get();
        OverrideSource source = MetaProviders.overrideSource(type, sourceMetaConfig.get("properties"));
        LOGGER.fine(() -> "Loaded override source of type \"" + type + "\", class: " + source.getClass().getName());
        return source;
    }

    static List<ConfigSource> configSources(Config metaConfig) {
        LinkedList<ConfigSource> configSources = new LinkedList<ConfigSource>();
        metaConfig.get("sources").asNodeList().ifPresent(list -> list.forEach(it -> configSources.addAll(MetaConfig.configSource(it))));
        return configSources;
    }

    static List<ConfigSource> configSources(Function<String, Boolean> supportedMediaType) {
        Optional<Config> metaConfigOpt = MetaConfig.metaConfig();
        return metaConfigOpt.map(MetaConfig::configSources).orElseGet(() -> MetaConfigFinder.findConfigSource(supportedMediaType).map(List::of).orElseGet(List::of));
    }

    private static Function<String, Boolean> supportedMediaTypes() {
        HashSet supportedMediaTypes = new HashSet();
        HelidonServiceLoader.create(ServiceLoader.load(ConfigParser.class)).forEach(parser -> supportedMediaTypes.addAll(parser.supportedMediaTypes()));
        return supportedMediaTypes::contains;
    }

    private static Config createDefault() {
        Config.Builder builder = Config.builder();
        MetaConfigFinder.findConfigSource(MetaConfig.supportedMediaTypes()).ifPresent(builder::addSource);
        return builder.build();
    }
}

