/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractSourceBuilder;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.RetryPolicy;
import io.helidon.config.spi.Source;
import java.util.Optional;

public class AbstractSource
implements Source {
    private final boolean optional;
    private final Optional<RetryPolicy> retryPolicy;
    private final Optional<PollingStrategy> pollingStrategy;
    private final Optional<ChangeWatcher<Object>> changeWatcher;

    protected AbstractSource(AbstractSourceBuilder<?, ?> builder) {
        this.optional = builder.isOptional();
        this.pollingStrategy = builder.pollingStrategy();
        this.retryPolicy = builder.retryPolicy();
        this.changeWatcher = builder.changeWatcher().map(it -> it);
    }

    @Override
    public Optional<RetryPolicy> retryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    protected Optional<PollingStrategy> pollingStrategy() {
        return this.pollingStrategy;
    }

    protected Optional<ChangeWatcher<Object>> changeWatcher() {
        return this.changeWatcher;
    }

    protected String uid() {
        return "";
    }

    @Override
    public String description() {
        return Source.super.description() + "[" + this.uid() + "]" + (this.optional() ? "?" : "") + (this.pollingStrategy().isEmpty() ? "" : "*");
    }
}

