/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigUtils;
import io.helidon.config.MissingValueException;
import io.helidon.config.UrlHelper;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ParsableSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UrlConfigSource
extends AbstractConfigSource
implements WatchableSource<URL>,
ParsableSource,
PollableSource<Instant> {
    private static final Logger LOGGER = Logger.getLogger(UrlConfigSource.class.getName());
    private static final String GET_METHOD = "GET";
    private static final String URL_KEY = "url";
    private static final int STATUS_NOT_FOUND = 404;
    private final URL url;

    private UrlConfigSource(Builder builder) {
        super(builder);
        this.url = builder.url;
    }

    public static UrlConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return UrlConfigSource.builder().config(metaConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String uid() {
        return this.url.toString();
    }

    @Override
    public URL target() {
        return this.url;
    }

    @Override
    public Class<URL> targetType() {
        return URL.class;
    }

    @Override
    public Optional<ConfigParser> parser() {
        return super.parser();
    }

    @Override
    public Optional<String> mediaType() {
        return super.mediaType();
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public Optional<ChangeWatcher<Object>> changeWatcher() {
        return super.changeWatcher();
    }

    @Override
    public boolean isModified(Instant stamp) {
        return UrlHelper.isModified(this.url, stamp);
    }

    @Override
    public Optional<ConfigParser.Content> load() throws ConfigException {
        try {
            URLConnection urlConnection = this.url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                return this.httpContent(httpURLConnection);
            }
            return this.genericContent(urlConnection);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at url '" + this.url + "' is not accessible.", ex);
        }
    }

    @Override
    public Function<String, Optional<InputStream>> relativeResolver() {
        String path = this.url.getPath();
        return it -> {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                lastSlash = path.lastIndexOf(92);
            }
            Object pathToFind = lastSlash == -1 ? it : path.substring(0, lastSlash + 1) + it;
            try {
                URL urlToFind = new URI(this.url.getProtocol(), this.url.getUserInfo(), this.url.getHost(), this.url.getPort(), (String)pathToFind, this.url.getQuery(), null).toURL();
                URLConnection connection = urlToFind.openConnection();
                if (connection instanceof HttpURLConnection) {
                    return this.httpStream(connection);
                }
                return Optional.of(connection.getInputStream());
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException("Configuration at url '" + this.url + "' with path + " + path + " is not accessible.", e);
            }
        };
    }

    private Optional<ConfigParser.Content> genericContent(URLConnection urlConnection) throws IOException {
        InputStream is = urlConnection.getInputStream();
        ConfigParser.Content.Builder builder = (ConfigParser.Content.Builder)ConfigParser.Content.builder().data(is).stamp(Instant.now());
        this.probeContentType().ifPresent(builder::mediaType);
        return Optional.ofNullable(builder.build());
    }

    private Optional<InputStream> httpStream(URLConnection urlConnection) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setRequestMethod(GET_METHOD);
        try {
            connection.connect();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Failed to connect to " + this.url + ", considering this source to be missing", e);
            return Optional.empty();
        }
        if (404 == connection.getResponseCode()) {
            return Optional.empty();
        }
        return Optional.of(connection.getInputStream());
    }

    private Optional<ConfigParser.Content> httpContent(HttpURLConnection connection) throws IOException {
        Instant timestamp;
        connection.setRequestMethod(GET_METHOD);
        try {
            connection.connect();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Failed to connect to " + this.url + ", considering this source to be missing", e);
            return Optional.empty();
        }
        if (404 == connection.getResponseCode()) {
            return Optional.empty();
        }
        Optional<String> mediaType = this.mediaType(connection.getContentType());
        if (connection.getLastModified() == 0L) {
            timestamp = Instant.now();
            LOGGER.fine("Missing GET '" + this.url + "' response header 'Last-Modified'. Used current time '" + timestamp + "' as a content timestamp.");
        } else {
            timestamp = Instant.ofEpochMilli(connection.getLastModified());
        }
        InputStream inputStream = connection.getInputStream();
        Charset charset = ConfigUtils.getContentCharset(connection.getContentEncoding());
        ConfigParser.Content.Builder builder = ConfigParser.Content.builder();
        builder.data(inputStream);
        builder.charset(charset);
        builder.stamp(timestamp);
        mediaType.ifPresent(builder::mediaType);
        return Optional.of(builder.build());
    }

    private Optional<String> mediaType(String responseMediaType) {
        return this.mediaType().or(() -> Optional.ofNullable(responseMediaType)).or(() -> {
            Optional<String> mediaType = this.probeContentType();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("HTTP response does not contain content-type, used guessed one: " + mediaType + ".");
            }
            return mediaType;
        });
    }

    private Optional<String> probeContentType() {
        return MediaTypes.detectType((URL)this.url);
    }

    public static final class Builder
    extends AbstractConfigSourceBuilder<Builder, URL>
    implements PollableSource.Builder<Builder>,
    WatchableSource.Builder<Builder, URL>,
    ParsableSource.Builder<Builder>,
    io.helidon.common.Builder<Builder, UrlConfigSource> {
        private URL url;

        private Builder() {
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get(UrlConfigSource.URL_KEY).as(URL.class).ifPresent(this::url);
            return (Builder)super.config(metaConfig);
        }

        public UrlConfigSource build() {
            if (null == this.url) {
                throw new IllegalArgumentException("url must be provided");
            }
            return new UrlConfigSource(this);
        }

        @Override
        public Builder parser(ConfigParser parser) {
            return (Builder)super.parser(parser);
        }

        @Override
        public Builder mediaType(String mediaType) {
            return (Builder)super.mediaType(mediaType);
        }

        @Override
        public Builder changeWatcher(ChangeWatcher<URL> changeWatcher) {
            return (Builder)super.changeWatcher(changeWatcher);
        }

        @Override
        public Builder pollingStrategy(PollingStrategy pollingStrategy) {
            return (Builder)super.pollingStrategy(pollingStrategy);
        }
    }
}

