/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigMapperProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

class ConfigMapperManager
implements ConfigMapper {
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final Map<GenericType<?>, Mapper<?>> mappers = new ConcurrentHashMap();
    private final MapperProviders mapperProviders;

    ConfigMapperManager(MapperProviders mapperProviders) {
        this.mapperProviders = mapperProviders;
    }

    @Override
    public <T> T map(Config config, Class<T> type) throws MissingValueException, ConfigMappingException {
        if (type.isArray()) {
            return this.mapArray(config, type);
        }
        return this.map(config, GenericType.create(ConfigMapperManager.supportedType(type)));
    }

    private <T> T mapArray(Config config, Class<T> type) {
        Class<?> componentType = type.getComponentType();
        List<?> listValue = config.asList(componentType).get();
        Object result = Array.newInstance(componentType, listValue.size());
        for (int i = 0; i < listValue.size(); ++i) {
            Object component = listValue.get(i);
            Array.set(result, i, component);
        }
        return (T)result;
    }

    @Override
    public <T> T map(Config config, GenericType<T> type) throws MissingValueException, ConfigMappingException {
        Mapper mapper = this.mappers.computeIfAbsent(type, theType -> this.findMapper((GenericType)theType, config.key()));
        return ConfigMapperManager.cast(type, mapper.apply(config, this), config.key());
    }

    @Override
    public <T> T map(String value, Class<T> type, String key) throws MissingValueException, ConfigMappingException {
        return this.map(this.simpleConfig(key, value), type);
    }

    @Override
    public <T> T map(String value, GenericType<T> type, String key) throws MissingValueException, ConfigMappingException {
        return this.map(this.simpleConfig(key, value), type);
    }

    private <T> Mapper<T> findMapper(GenericType<T> type, Config.Key key) {
        return this.mapperProviders.findMapper(type, key).orElseGet(() -> this.noMapper(type));
    }

    private <T> Mapper<T> noMapper(GenericType<T> type) {
        return new NoMapperFound<T>(type);
    }

    static <T> T cast(GenericType<T> type, Object instance, Config.Key key) throws ConfigMappingException {
        try {
            return (T)instance;
        }
        catch (ClassCastException ex) {
            throw new ConfigMappingException(key, (Type)type, "Created instance is not assignable to the type.", (Throwable)ex);
        }
    }

    public static <T> Class<T> supportedType(Class<T> type) {
        return REPLACED_TYPES.getOrDefault(type, type);
    }

    Config simpleConfig(String name, String stringValue) {
        return new SingleValueConfigImpl(this, name, stringValue);
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    static final class MapperProviders {
        private final LinkedList<Function<GenericType<?>, Optional<? extends BiFunction<Config, ConfigMapper, ?>>>> providers = new LinkedList();

        private MapperProviders() {
        }

        static MapperProviders create() {
            return new MapperProviders();
        }

        void add(Function<GenericType<?>, Optional<? extends BiFunction<Config, ConfigMapper, ?>>> function) {
            this.providers.addFirst(function);
        }

        void add(ConfigMapperProvider provider) {
            this.add(new ProviderWrapper(provider));
        }

        void addAll(MapperProviders other) {
            LinkedList otherProviders = new LinkedList(other.providers);
            Collections.reverse(otherProviders);
            otherProviders.forEach(this::add);
        }

        <T> Optional<Mapper<T>> findMapper(GenericType<T> type, Config.Key key) {
            return this.providers.stream().map(provider -> (Optional)provider.apply(type)).flatMap(Optional::stream).findFirst().map(mapper -> MapperProviders.castMapper(type, mapper, key)).map(Mapper::create);
        }

        private static <T> BiFunction<Config, ConfigMapper, T> castMapper(GenericType<T> type, BiFunction<Config, ConfigMapper, ?> mapper, Config.Key key) {
            try {
                return mapper;
            }
            catch (ClassCastException e) {
                throw new ConfigMappingException(key, (Type)type, "Mapper provider returned wrong mapper type", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    static interface Mapper<T>
    extends BiFunction<Config, ConfigMapper, T> {
        public static <T> Mapper<T> create(BiFunction<Config, ConfigMapper, T> function) {
            return function::apply;
        }

        public static <T> Mapper<T> create(Function<Config, T> function) {
            return (config, configMapper) -> function.apply((Config)config);
        }
    }

    private static final class NoMapperFound<T>
    implements Mapper<T> {
        private final GenericType<T> type;

        private NoMapperFound(GenericType<T> type) {
            this.type = type;
        }

        @Override
        public T apply(Config config, ConfigMapper configMapper) {
            throw new ConfigMappingException(config.key(), (Type)this.type, "No mapper configured");
        }

        public String toString() {
            return "Mapper for " + this.type.getTypeName() + " is not defined";
        }
    }

    static class SingleValueConfigImpl
    implements Config {
        private final ConfigMapperManager mapperManager;
        private final Config.Key key;
        private final String value;
        private final Instant timestamp;

        SingleValueConfigImpl(ConfigMapperManager mapperManager, String key, String value) {
            this.mapperManager = mapperManager;
            this.key = Config.Key.create(key);
            this.value = value;
            this.timestamp = Instant.now();
        }

        @Override
        public boolean hasValue() {
            return null != this.value;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        @Override
        public ConfigValue<String> asString() {
            return ConfigValues.create((Config)this, () -> Optional.ofNullable(this.value), Config::asString);
        }

        @Override
        public Config.Type type() {
            return Config.Type.VALUE;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public Config get(Config.Key key) {
            if (key.isRoot()) {
                return this;
            }
            return Config.empty().get(this.key).get(key);
        }

        @Override
        public Config detach() {
            if (this.key.isRoot()) {
                return this;
            }
            return new SingleValueConfigImpl(this.mapperManager, "", this.value);
        }

        @Override
        public Stream<Config> traverse(Predicate<Config> predicate) {
            return Stream.empty();
        }

        @Override
        public <T> ConfigValue<T> as(Class<T> type) {
            return ConfigValues.create((Config)this, type, this.mapperManager);
        }

        @Override
        public <T> ConfigValue<T> as(Function<Config, T> mapper) {
            return ConfigValues.create(this, mapper);
        }

        @Override
        public <T> ConfigValue<T> as(GenericType<T> genericType) {
            return ConfigValues.create((Config)this, genericType, this.mapperManager);
        }

        @Override
        public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
            return ConfigValues.create((Config)this, () -> Optional.of(List.of(this)), Config::asNodeList);
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
            return ConfigValues.create((Config)this, () -> this.as(type).map(List::of), (Config config) -> config.asList(type));
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
            return ConfigValues.create((Config)this, () -> this.as(mapper).map(List::of), (Config config) -> config.asList(mapper));
        }

        @Override
        public ConfigValue<Map<String, String>> asMap() {
            return ConfigValues.createMap(this, this.mapperManager);
        }

        @Override
        public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
            return this.mapperManager.map(this.mapperManager.simpleConfig("", value), type);
        }

        @Override
        public ConfigValue<Config> asNode() {
            return this.as(Config.class);
        }

        @Override
        public ConfigMapper mapper() {
            return this.mapperManager;
        }
    }

    private static final class ProviderWrapper
    implements Function<GenericType<?>, Optional<? extends BiFunction<Config, ConfigMapper, ?>>> {
        private final ConfigMapperProvider provider;

        private ProviderWrapper(ConfigMapperProvider wrapped) {
            this.provider = wrapped;
        }

        @Override
        public Optional<? extends BiFunction<Config, ConfigMapper, ?>> apply(GenericType<?> genericType) {
            BiFunction<Config, ConfigMapper, ?> converter = this.provider.genericTypeMappers().get(genericType);
            if (null != converter) {
                return Optional.of(converter);
            }
            Optional<BiFunction<Config, ConfigMapper, ?>> mapper1 = this.provider.mapper(genericType);
            if (mapper1.isPresent()) {
                return mapper1;
            }
            if (!genericType.isClass()) {
                return Optional.empty();
            }
            Class rawType = genericType.rawType();
            Function<Config, ?> configConverter = this.provider.mappers().get(rawType);
            if (null != configConverter) {
                return Optional.of((config, mapper) -> configConverter.apply((Config)config));
            }
            return this.provider.mapper(rawType).map(funct -> (config, mapper) -> funct.apply(config));
        }

        public String toString() {
            return this.provider.toString();
        }
    }
}

