/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ConfigMappers {
    private static final Map<Class<?>, Function<Config, ?>> ESSENTIAL_MAPPERS = ConfigMappers.initEssentialMappers();
    static final Map<Class<?>, Function<Config, ?>> BUILT_IN_MAPPERS = ConfigMappers.initBuiltInMappers();

    private ConfigMappers() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    private static Map<Class<?>, Function<Config, ?>> initEssentialMappers() {
        return Map.of(Config.class, node -> node, String.class, ConfigMappers.wrap(value -> value), OptionalInt.class, ConfigMappers::optionalIntEssential, OptionalLong.class, ConfigMappers::optionalLongEssential, OptionalDouble.class, ConfigMappers::optionalDoubleEssential);
    }

    static Map<Class<?>, Function<Config, ?>> essentialMappers() {
        return ESSENTIAL_MAPPERS;
    }

    private static OptionalDouble optionalDoubleEssential(Config node) {
        if (!node.exists()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(ConfigMappers.wrap(Double::parseDouble).apply(node));
    }

    private static OptionalLong optionalLongEssential(Config node) {
        if (!node.exists()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(ConfigMappers.wrap(Long::parseLong).apply(node));
    }

    private static OptionalInt optionalIntEssential(Config node) {
        if (!node.exists()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ConfigMappers.wrap(Integer::parseInt).apply(node));
    }

    private static Map<Class<?>, Function<Config, ?>> initBuiltInMappers() {
        return Map.ofEntries(Map.entry(Byte.class, ConfigMappers.wrap(ConfigMappers::toByte)), Map.entry(Short.class, ConfigMappers.wrap(ConfigMappers::toShort)), Map.entry(Integer.class, ConfigMappers.wrap(ConfigMappers::toInt)), Map.entry(Long.class, ConfigMappers.wrap(ConfigMappers::toLong)), Map.entry(Float.class, ConfigMappers.wrap(ConfigMappers::toFloat)), Map.entry(Double.class, ConfigMappers.wrap(ConfigMappers::toDouble)), Map.entry(Boolean.class, ConfigMappers.wrap(ConfigMappers::toBoolean)), Map.entry(Character.class, ConfigMappers.wrap(ConfigMappers::toChar)), Map.entry(Class.class, ConfigMappers.wrap(ConfigMappers::toClass)), Map.entry(BigDecimal.class, ConfigMappers.wrap(ConfigMappers::toBigDecimal)), Map.entry(BigInteger.class, ConfigMappers.wrap(ConfigMappers::toBigInteger)), Map.entry(Duration.class, ConfigMappers.wrap(ConfigMappers::toDuration)), Map.entry(Period.class, ConfigMappers.wrap(ConfigMappers::toPeriod)), Map.entry(LocalDate.class, ConfigMappers.wrap(ConfigMappers::toLocalDate)), Map.entry(LocalDateTime.class, ConfigMappers.wrap(ConfigMappers::toLocalDateTime)), Map.entry(LocalTime.class, ConfigMappers.wrap(ConfigMappers::toLocalTime)), Map.entry(ZonedDateTime.class, ConfigMappers.wrap(ConfigMappers::toZonedDateTime)), Map.entry(ZoneId.class, ConfigMappers.wrap(ConfigMappers::toZoneId)), Map.entry(ZoneOffset.class, ConfigMappers.wrap(ConfigMappers::toZoneOffset)), Map.entry(Instant.class, ConfigMappers.wrap(ConfigMappers::toInstant)), Map.entry(OffsetTime.class, ConfigMappers.wrap(ConfigMappers::toOffsetTime)), Map.entry(OffsetDateTime.class, ConfigMappers.wrap(ConfigMappers::toOffsetDateTime)), Map.entry(YearMonth.class, ConfigMappers.wrap(YearMonth::parse)), Map.entry(File.class, ConfigMappers.wrap(ConfigMappers::toFile)), Map.entry(Path.class, ConfigMappers.wrap(ConfigMappers::toPath)), Map.entry(Charset.class, ConfigMappers.wrap(ConfigMappers::toCharset)), Map.entry(URI.class, ConfigMappers.wrap(ConfigMappers::toUri)), Map.entry(URL.class, ConfigMappers.wrap(ConfigMappers::toUrl)), Map.entry(Pattern.class, ConfigMappers.wrap(ConfigMappers::toPattern)), Map.entry(UUID.class, ConfigMappers.wrap(ConfigMappers::toUUID)), Map.entry(Map.class, ConfigMappers.wrapMapper(ConfigMappers::toMap)), Map.entry(Properties.class, ConfigMappers.wrapMapper(ConfigMappers::toProperties)), Map.entry(Date.class, ConfigMappers.wrap(ConfigMappers::toDate)), Map.entry(Calendar.class, ConfigMappers.wrap(ConfigMappers::toCalendar)), Map.entry(GregorianCalendar.class, ConfigMappers.wrap(ConfigMappers::toGregorianCalendar)), Map.entry(TimeZone.class, ConfigMappers.wrap(ConfigMappers::toTimeZone)), Map.entry(SimpleTimeZone.class, ConfigMappers.wrap(ConfigMappers::toSimpleTimeZone)));
    }

    static Map<Class<?>, Function<Config, ?>> builtInMappers() {
        return BUILT_IN_MAPPERS;
    }

    public static Byte toByte(String stringValue) {
        return Byte.parseByte(stringValue);
    }

    public static Short toShort(String stringValue) {
        return Short.parseShort(stringValue);
    }

    public static Integer toInt(String stringValue) {
        return Integer.parseInt(stringValue);
    }

    public static Long toLong(String stringValue) {
        return Long.parseLong(stringValue);
    }

    public static Float toFloat(String stringValue) {
        return Float.valueOf(Float.parseFloat(stringValue));
    }

    public static Double toDouble(String stringValue) {
        return Double.parseDouble(stringValue);
    }

    public static Boolean toBoolean(String stringValue) {
        String lower;
        switch (lower = stringValue.toLowerCase()) {
            case "true": 
            case "1": 
            case "yes": 
            case "y": 
            case "on": {
                return true;
            }
        }
        return false;
    }

    public static Character toChar(String stringValue) {
        if (stringValue.length() != 1) {
            throw new IllegalArgumentException("Cannot convert to 'char'. The value must be just single character, but was '" + stringValue + "'.");
        }
        return Character.valueOf(stringValue.charAt(0));
    }

    public static Class<?> toClass(String stringValue) {
        try {
            return Class.forName(stringValue);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static UUID toUUID(String stringValue) {
        return UUID.fromString(stringValue);
    }

    public static BigDecimal toBigDecimal(String stringValue) {
        return new BigDecimal(stringValue);
    }

    public static BigInteger toBigInteger(String stringValue) {
        return new BigInteger(stringValue);
    }

    public static File toFile(String stringValue) {
        return new File(stringValue);
    }

    public static Path toPath(String stringValue) {
        return Paths.get(stringValue, new String[0]);
    }

    public static Charset toCharset(String stringValue) {
        return Charset.forName(stringValue);
    }

    public static Pattern toPattern(String stringValue) {
        return Pattern.compile(stringValue);
    }

    public static URI toUri(String stringValue) {
        return URI.create(stringValue);
    }

    public static URL toUrl(String stringValue) {
        try {
            return new URL(stringValue);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static Date toDate(String stringValue) {
        try {
            return new Date(Instant.from(ConfigMappers.buildDateTimeFormatter(stringValue).parse(stringValue)).toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static DateTimeFormatter buildDateTimeFormatter(String stringValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        ParsePosition pp = new ParsePosition(0);
        TemporalAccessor accessor = formatter.parseUnresolved(stringValue, pp);
        if (!accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            formatter = formatter.withZone(ZoneId.of("UTC"));
        }
        return formatter;
    }

    @Deprecated
    public static Calendar toCalendar(String stringValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ConfigMappers.toDate(stringValue));
        return calendar;
    }

    @Deprecated
    public static GregorianCalendar toGregorianCalendar(String stringValue) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ConfigMappers.toDate(stringValue));
        return calendar;
    }

    public static LocalDate toLocalDate(String stringValue) {
        return LocalDate.parse(stringValue);
    }

    public static LocalTime toLocalTime(String stringValue) {
        return LocalTime.parse(stringValue);
    }

    public static LocalDateTime toLocalDateTime(String stringValue) {
        return LocalDateTime.parse(stringValue);
    }

    public static ZonedDateTime toZonedDateTime(String stringValue) {
        return ZonedDateTime.parse(stringValue);
    }

    public static ZoneId toZoneId(String stringValue) {
        return ZoneId.of(stringValue);
    }

    public static ZoneOffset toZoneOffset(String stringValue) {
        return ZoneOffset.of(stringValue);
    }

    @Deprecated
    public static TimeZone toTimeZone(String stringValue) {
        ZoneId zoneId = ConfigMappers.toZoneId(stringValue);
        return TimeZone.getTimeZone(zoneId);
    }

    @Deprecated
    public static SimpleTimeZone toSimpleTimeZone(String stringValue) {
        return new SimpleTimeZone(ConfigMappers.toTimeZone(stringValue).getRawOffset(), stringValue);
    }

    public static Instant toInstant(String stringValue) {
        return Instant.parse(stringValue);
    }

    public static OffsetDateTime toOffsetDateTime(String stringValue) {
        return OffsetDateTime.parse(stringValue);
    }

    public static OffsetTime toOffsetTime(String stringValue) {
        return OffsetTime.parse(stringValue);
    }

    public static Duration toDuration(String stringValue) {
        return Duration.parse(stringValue);
    }

    public static Period toPeriod(String stringValue) {
        return Period.parse(stringValue);
    }

    public static Map<String, String> toMap(Config config) {
        if (config.isLeaf()) {
            return new StringMap(Config.Key.unescapeName(config.key().toString()), (String)config.asString().get());
        }
        return new StringMap(config.traverse().filter(Config::isLeaf).map(node -> new AbstractMap.SimpleEntry<String, String>(Config.Key.unescapeName(node.key().toString()), (String)node.asString().get())).collect(Collectors.toSet()));
    }

    public static Properties toProperties(Config config) {
        Properties properties = new Properties();
        ConfigMappers.toMap(config).forEach(properties::setProperty);
        return properties;
    }

    private static <T> Function<Config, T> wrapMapper(Function<Config, T> mapper) {
        return node -> {
            try {
                return mapper.apply((Config)node);
            }
            catch (ConfigMappingException | MissingValueException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new ConfigMappingException(node.key(), "Invocation of mapper '" + String.valueOf(mapper) + "' has failed with an exception.", ex);
            }
        };
    }

    static <T> Function<Config, T> wrap(Function<String, T> mapper) {
        return node -> ConfigMappers.nodeValue(node).map(value -> ConfigMappers.safeMap(node.key(), value, mapper)).orElseThrow(MissingValueException.createSupplier(node.key()));
    }

    private static Optional<String> nodeValue(Config node) {
        if (node instanceof AbstractConfigImpl) {
            return ((AbstractConfigImpl)node).value();
        }
        return node.asString().asOptional();
    }

    private static <T> T safeMap(Config.Key key, String value, Function<String, T> mapper) throws ConfigMappingException {
        try {
            return mapper.apply(value);
        }
        catch (ConfigMappingException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ConfigMappingException(key, value, "Invocation of mapper '" + String.valueOf(mapper) + "' has failed with an exception.", (Throwable)ex);
        }
    }

    static class StringMap
    extends AbstractMap<String, String>
    implements Map<String, String> {
        private final Set<Map.Entry<String, String>> entrySet;

        StringMap(Set<Map.Entry<String, String>> entrySet) {
            this.entrySet = entrySet;
        }

        StringMap(String key, String value) {
            this(Set.of(Map.entry(key, value)));
        }

        StringMap(Map<?, ?> unknownMap) {
            this(StringMap.wrap(unknownMap.entrySet()));
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.entrySet;
        }

        private static Set<Map.Entry<String, String>> wrap(Set<? extends Map.Entry<?, ?>> unknownEntrySet) {
            return unknownEntrySet.stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()))).collect(Collectors.toSet());
        }
    }
}

