/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.MissingValueException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ConfigValues {
    private ConfigValues() {
    }

    public static <T> ConfigValue<T> empty() {
        return new ConfigValueBase<T>(Config.Key.create("")){

            @Override
            public Optional<T> asOptional() {
                return Optional.empty();
            }

            @Override
            public <N> ConfigValue<N> as(Function<T, N> mapper) {
                return ConfigValues.empty();
            }

            @Override
            public Supplier<T> supplier() {
                return () -> {
                    throw MissingValueException.create(this.key());
                };
            }

            @Override
            public Supplier<T> supplier(T defaultValue) {
                return () -> defaultValue;
            }

            @Override
            public Supplier<Optional<T>> optionalSupplier() {
                return Optional::empty;
            }

            public String toString() {
                return "ConfigValue(empty)";
            }
        };
    }

    public static <T> ConfigValue<T> simpleValue(final T value) {
        return new ConfigValueBase<T>(Config.Key.create("")){

            @Override
            public Optional<T> asOptional() {
                return Optional.ofNullable(value);
            }

            @Override
            public <N> ConfigValue<N> as(Function<T, N> mapper) {
                return ConfigValues.simpleValue(mapper.apply(value));
            }

            @Override
            public Supplier<T> supplier() {
                return () -> value;
            }

            @Override
            public Supplier<T> supplier(T defaultValue) {
                return () -> this.asOptional().orElse(defaultValue);
            }

            @Override
            public Supplier<Optional<T>> optionalSupplier() {
                return this::asOptional;
            }

            public String toString() {
                return "ConfigValue(" + String.valueOf(value) + ")";
            }
        };
    }

    static <T> ConfigValue<T> create(Config config, Supplier<Optional<T>> supplier, Function<Config, ConfigValue<T>> configMethod) {
        return new GenericConfigValueImpl<T>(config, supplier, configMethod);
    }

    static <T> ConfigValue<T> create(Config config, Class<T> type, ConfigMapperManager mapperManager) {
        return new GenericConfigValueImpl(config, () -> Optional.ofNullable(mapperManager.map(config, type)), aConfig -> aConfig.as(type));
    }

    static <T> ConfigValue<T> create(Config config, GenericType<T> genericType, ConfigMapperManager mapperManager) {
        return new GenericConfigValueImpl(config, () -> Optional.ofNullable(mapperManager.map(config, genericType)), aConfig -> aConfig.as(genericType));
    }

    static <T> ConfigValue<T> create(Config config, Function<Config, T> mapper) {
        return new GenericConfigValueImpl(config, () -> Optional.ofNullable(mapper.apply(config)), aConfig -> aConfig.as(mapper));
    }

    static <T> ConfigValue<List<T>> createList(Config config, Function<Config, ConfigValue<T>> getValue, Function<Config, ConfigValue<List<T>>> getListValue) {
        Supplier valueSupplier = () -> {
            try {
                return config.asNodeList().map(list -> list.stream().map(theConfig -> ((ConfigValue)getValue.apply((Config)theConfig)).get()).collect(Collectors.toList()));
            }
            catch (ConfigMappingException | MissingValueException ex) {
                throw new ConfigMappingException(config.key(), "Error to map complex node item to list. " + ex.getLocalizedMessage(), (Throwable)((Object)ex));
            }
        };
        return new GenericConfigValueImpl<List<T>>(config, valueSupplier, getListValue);
    }

    static ConfigValue<Map<String, String>> createMap(Config config, ConfigMapperManager mapperManager) {
        Supplier valueSupplier = () -> {
            Map<String, Object> map = mapperManager.map(config, Map.class);
            if ((map = map.entrySet().stream().collect(Collectors.toMap(entry -> Config.Key.unescapeName(entry.getKey().toString()), entry -> entry.getValue()))) instanceof ConfigMappers.StringMap) {
                return Optional.of((ConfigMappers.StringMap)map);
            }
            return Optional.of(new ConfigMappers.StringMap(map));
        };
        return new GenericConfigValueImpl<Map<String, String>>(config, valueSupplier, Config::asMap);
    }

    private static final class GenericConfigValueImpl<T>
    extends ConfigValueBase<T> {
        private final Supplier<Optional<T>> valueSupplier;
        private final Function<Config, ConfigValue<T>> configMethod;
        private final Config owningConfig;

        private GenericConfigValueImpl(Config owningConfig, Supplier<Optional<T>> valueSupplier, Function<Config, ConfigValue<T>> configMethod) {
            super(owningConfig.key());
            this.owningConfig = owningConfig;
            this.valueSupplier = valueSupplier;
            this.configMethod = configMethod;
        }

        @Override
        public Optional<T> asOptional() {
            try {
                return this.valueSupplier.get();
            }
            catch (MissingValueException e) {
                return Optional.empty();
            }
        }

        @Override
        public Supplier<T> supplier() {
            return () -> this.configMethod.apply(this.latest()).get();
        }

        @Override
        public Supplier<T> supplier(T defaultValue) {
            return () -> this.configMethod.apply(this.latest()).orElse(defaultValue);
        }

        @Override
        public Supplier<Optional<T>> optionalSupplier() {
            return () -> this.configMethod.apply(this.latest()).asOptional();
        }

        private Config latest() {
            return this.owningConfig.context().last();
        }

        @Override
        public <N> ConfigValue<N> as(Function<T, N> mapper) {
            return new GenericConfigValueImpl<T>(this.owningConfig, () -> this.map(mapper), config -> this.configMethod.apply((Config)config).as(mapper));
        }

        public String toString() {
            return String.valueOf(this.key()) + ": " + this.asOptional().map(String::valueOf).orElse("");
        }
    }

    private static abstract class ConfigValueBase<T>
    implements ConfigValue<T> {
        private final Config.Key key;

        protected ConfigValueBase(Config.Key key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConfigValue) {
                return ((ConfigValue)obj).asOptional().equals(this.asOptional());
            }
            return false;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        public int hashCode() {
            return this.asOptional().hashCode();
        }
    }
}

