/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;

public final class DeprecatedConfig {
    private static final System.Logger LOGGER = System.getLogger(DeprecatedConfig.class.getName());

    private DeprecatedConfig() {
    }

    public static Config get(Config config, String currentKey, String deprecatedKey) {
        Config deprecatedConfig = config.get(deprecatedKey);
        Config currentConfig = config.get(currentKey);
        if (deprecatedConfig.exists()) {
            if (currentConfig.exists()) {
                LOGGER.log(System.Logger.Level.WARNING, "You are using both a deprecated configuration and a current one. Deprecated key: \"" + String.valueOf(deprecatedConfig.key()) + "\", current key: \"" + String.valueOf(currentConfig.key()) + "\", only the current key will be used, and deprecated will be ignored.");
                return currentConfig;
            }
            LOGGER.log(System.Logger.Level.WARNING, "You are using a deprecated configuration key. Deprecated key: \"" + String.valueOf(deprecatedConfig.key()) + "\", current key: \"" + String.valueOf(currentConfig.key()) + "\".");
            return deprecatedConfig;
        }
        return currentConfig;
    }
}

