/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigFilter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueResolvingFilter
implements ConfigFilter {
    private static final System.Logger LOGGER = System.getLogger(ValueResolvingFilter.class.getName());
    private static final boolean DEFAULT_FAIL_ON_MISSING_REFERENCE_BEHAVIOR = false;
    private static final String REGEX_REFERENCE = "(?<!\\\\)\\$\\{([^}]+)\\}";
    private static final Pattern PATTERN_REFERENCE = Pattern.compile("(?<!\\\\)\\$\\{([^}]+)\\}");
    static final String MISSING_REFERENCE_ERROR = "A value of the key '%s' references to the missing key, see stacktrace.";
    private static final String REGEX_BACKSLASH = "\\\\(?=\\$\\{([^}]+)\\})";
    private static final Pattern PATTERN_BACKSLASH = Pattern.compile("\\\\(?=\\$\\{([^}]+)\\})");
    private static final ThreadLocal<Set<Config.Key>> UNRESOLVED_KEYS = ThreadLocal.withInitial(HashSet::new);
    private Config root;
    private Optional<Boolean> failOnMissingReferenceSetting = Optional.empty();
    private boolean failOnMissingReference = false;

    public ValueResolvingFilter(boolean failOnMissingReference) {
        this.failOnMissingReferenceSetting = Optional.of(failOnMissingReference);
    }

    public ValueResolvingFilter() {
    }

    @Override
    public void init(Config config) {
        this.root = config;
        if (this.failOnMissingReferenceSetting.isEmpty()) {
            this.failOnMissingReferenceSetting = Optional.of(config.get("config.value-resolving-filter.fail-on-missing-reference").asBoolean().orElse(false));
        }
        this.failOnMissingReference = this.failOnMissingReferenceSetting.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(Config.Key key, String stringValue) {
        if (!UNRESOLVED_KEYS.get().add(key)) {
            UNRESOLVED_KEYS.get().clear();
            throw new IllegalStateException("Recursive update");
        }
        try {
            String string = this.format(stringValue);
            return string;
        }
        catch (MissingValueException e) {
            if (this.failOnMissingReference) {
                throw new ConfigException(String.format(MISSING_REFERENCE_ERROR, key.name()), (Throwable)((Object)e));
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format(MISSING_REFERENCE_ERROR, key.name()), (Throwable)((Object)e));
            }
            String string = stringValue;
            return string;
        }
        finally {
            UNRESOLVED_KEYS.get().remove(key);
        }
    }

    private String format(String template) {
        Matcher m = PATTERN_REFERENCE.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, Matcher.quoteReplacement((String)this.root.get(m.group(1)).asString().get()));
        }
        m.appendTail(sb);
        m = PATTERN_BACKSLASH.matcher(sb.toString());
        return m.replaceAll("");
    }
}

