/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.media.type.MediaType;
import io.helidon.config.AbstractConfigSource;
import io.helidon.config.BuilderImpl;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigSourceRuntime;
import io.helidon.config.spi.ChangeEventType;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.EventConfigSource;
import io.helidon.config.spi.LazyConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.ParsableSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class ConfigSourceRuntimeImpl
implements ConfigSourceRuntime {
    private static final System.Logger LOGGER = System.getLogger(ConfigSourceRuntimeImpl.class.getName());
    private final List<BiConsumer<String, ConfigNode>> listeners = new LinkedList<BiConsumer<String, ConfigNode>>();
    private final BuilderImpl.ConfigContextImpl configContext;
    private final ConfigSource configSource;
    private final boolean changesSupported;
    private final Supplier<Optional<ConfigNode.ObjectNode>> reloader;
    private final Runnable changesRunnable;
    private final Function<String, Optional<ConfigNode>> singleNodeFunction;
    private final boolean isLazy;
    private boolean changesWanted = false;
    private boolean changesStarted = false;
    private boolean dataLoaded = false;
    private Optional<ConfigNode.ObjectNode> initialData;
    private Map<String, ConfigNode> loadedData;

    ConfigSourceRuntimeImpl(BuilderImpl.ConfigContextImpl configContext, ConfigSource source) {
        PollableSource pollable;
        Optional<PollingStrategy> pollingStrategy;
        WatchableSource watchable;
        Optional<ChangeWatcher<Object>> changeWatcher;
        Function<String, Optional<ConfigNode>> singleNodeFunction;
        Supplier<Optional<ConfigNode.ObjectNode>> reloader;
        this.configContext = configContext;
        this.configSource = source;
        boolean lazy = false;
        AtomicReference<Object> lastStamp = new AtomicReference<Object>();
        if (this.configSource instanceof ParsableSource) {
            reloader = new ParsableConfigSourceReloader(configContext, (ParsableSource)((Object)source), lastStamp);
            singleNodeFunction = this.objectNodeToSingleNode();
        } else if (this.configSource instanceof NodeConfigSource) {
            reloader = new NodeConfigSourceReloader((NodeConfigSource)source, lastStamp);
            singleNodeFunction = this.objectNodeToSingleNode();
        } else if (this.configSource instanceof LazyConfigSource) {
            LazyConfigSource lazySource = (LazyConfigSource)((Object)source);
            reloader = Optional::empty;
            singleNodeFunction = lazySource::node;
            lazy = true;
        } else {
            throw new ConfigException("Config source " + String.valueOf(source) + ", class: " + source.getClass().getName() + " does not implement any of required interfaces. A config source must at least implement one of the following: ParsableSource, or NodeConfigSource, or LazyConfigSource");
        }
        this.isLazy = lazy;
        this.reloader = reloader;
        this.singleNodeFunction = singleNodeFunction;
        boolean changesSupported = false;
        Runnable changesRunnable = null;
        if (this.configSource instanceof WatchableSource && (changeWatcher = (watchable = (WatchableSource)((Object)source)).changeWatcher()).isPresent()) {
            changesSupported = true;
            changesRunnable = new WatchableChangesStarter(configContext, this.listeners, reloader, source, watchable, changeWatcher.get());
        }
        if (!changesSupported && this.configSource instanceof PollableSource && (pollingStrategy = (pollable = (PollableSource)((Object)source)).pollingStrategy()).isPresent()) {
            changesSupported = true;
            changesRunnable = new PollingStrategyStarter(configContext, this.listeners, reloader, source, pollable, pollingStrategy.get(), lastStamp);
        }
        if (!changesSupported && this.configSource instanceof EventConfigSource) {
            EventConfigSource event = (EventConfigSource)((Object)source);
            changesSupported = true;
            changesRunnable = () -> event.onChange((key, config) -> this.listeners.forEach(it -> it.accept(key, config)));
        }
        this.changesRunnable = changesRunnable;
        this.changesSupported = changesSupported;
    }

    @Override
    public synchronized void onChange(BiConsumer<String, ConfigNode> change) {
        if (!this.changesSupported) {
            return;
        }
        this.listeners.add(change);
        this.changesWanted = true;
        this.startChanges();
    }

    @Override
    public synchronized Optional<ConfigNode.ObjectNode> load() {
        if (this.dataLoaded) {
            throw new ConfigException("Attempting to load a single config source multiple times. This is a bug.");
        }
        this.initialLoad();
        return this.initialData;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    boolean changesSupported() {
        return this.changesSupported;
    }

    public String toString() {
        return "Runtime for " + String.valueOf(this.configSource);
    }

    public int hashCode() {
        return Objects.hash(this.configSource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSourceRuntimeImpl that = (ConfigSourceRuntimeImpl)o;
        return this.configSource.equals(that.configSource);
    }

    private synchronized void initialLoad() {
        if (this.dataLoaded) {
            return;
        }
        this.configSource.init(this.configContext);
        Optional<ConfigNode.ObjectNode> loadedData = this.configSource.retryPolicy().map(policy -> policy.execute(this.reloader)).orElseGet(this.reloader);
        if (loadedData.isEmpty() && !this.configSource.optional()) {
            throw new ConfigException("Cannot load data from mandatory source: " + String.valueOf(this.configSource));
        }
        if (this.configSource instanceof AbstractConfigSource) {
            loadedData = loadedData.map(it -> ((AbstractConfigSource)this.configSource).processNodeMapping(this.configContext::findParser, ConfigKeyImpl.of(), (ConfigNode.ObjectNode)it));
        }
        this.initialData = loadedData;
        this.loadedData = new HashMap<String, ConfigNode>();
        this.initialData.ifPresent(data -> {
            Map<ConfigKeyImpl, ConfigNode> keyToNodeMap = ConfigHelper.createFullKeyToNodeMap(data);
            keyToNodeMap.forEach((key, value) -> this.loadedData.put(key.toString(), (ConfigNode)value));
        });
        this.dataLoaded = true;
        this.startChanges();
    }

    @Override
    public Optional<ConfigNode> node(String key) {
        return this.singleNodeFunction.apply(key);
    }

    @Override
    public String description() {
        return this.configSource.description();
    }

    private Function<String, Optional<ConfigNode>> objectNodeToSingleNode() {
        return key -> {
            if (null == this.loadedData) {
                throw new IllegalStateException("Single node of an eager source requested before load method was called. This is a bug.");
            }
            return Optional.ofNullable(this.loadedData.get(key));
        };
    }

    private void startChanges() {
        if (!this.changesStarted && this.dataLoaded && this.changesWanted) {
            this.changesStarted = true;
            this.changesRunnable.run();
        }
    }

    private static void triggerChanges(BuilderImpl.ConfigContextImpl configContext, List<BiConsumer<String, ConfigNode>> listeners, Optional<ConfigNode.ObjectNode> objectNode) {
        configContext.changesExecutor().execute(() -> {
            for (BiConsumer listener : listeners) {
                listener.accept("", (ConfigNode)objectNode.orElse(ConfigNode.ObjectNode.empty()));
            }
        });
    }

    private static final class ParsableConfigSourceReloader
    implements Supplier<Optional<ConfigNode.ObjectNode>> {
        private final BuilderImpl.ConfigContextImpl configContext;
        private final ParsableSource configSource;
        private final AtomicReference<Object> lastStamp;

        private ParsableConfigSourceReloader(BuilderImpl.ConfigContextImpl configContext, ParsableSource configSource, AtomicReference<Object> lastStamp) {
            this.configContext = configContext;
            this.configSource = configSource;
            this.lastStamp = lastStamp;
        }

        @Override
        public Optional<ConfigNode.ObjectNode> get() {
            return this.configSource.load().map(content -> {
                this.lastStamp.set(content.stamp().orElse(null));
                Optional<ConfigParser> parser = this.configSource.parser();
                if (parser.isPresent()) {
                    return parser.get().parse((ConfigParser.Content)content, this.configSource.relativeResolver());
                }
                Optional<MediaType> mediaType = this.configSource.mediaType().or(content::mediaType);
                if (mediaType.isPresent()) {
                    parser = this.configContext.findParser(mediaType.get());
                    if (parser.isEmpty()) {
                        throw new ConfigException("Cannot find suitable parser for '" + String.valueOf(mediaType.get()) + "' media type for config source " + this.configSource.description());
                    }
                    return parser.get().parse((ConfigParser.Content)content, this.configSource.relativeResolver());
                }
                throw new ConfigException("Could not find media type of config source " + this.configSource.description());
            });
        }
    }

    private static final class NodeConfigSourceReloader
    implements Supplier<Optional<ConfigNode.ObjectNode>> {
        private final NodeConfigSource configSource;
        private final AtomicReference<Object> lastStamp;

        private NodeConfigSourceReloader(NodeConfigSource configSource, AtomicReference<Object> lastStamp) {
            this.configSource = configSource;
            this.lastStamp = lastStamp;
        }

        @Override
        public Optional<ConfigNode.ObjectNode> get() {
            return this.configSource.load().map(content -> {
                this.lastStamp.set(content.stamp().orElse(null));
                return content.data();
            });
        }
    }

    private static final class WatchableChangesStarter
    implements Runnable {
        private final WatchableSource<Object> watchable;
        private final WatchableListener listener;
        private final ChangeWatcher<Object> changeWatcher;

        private WatchableChangesStarter(BuilderImpl.ConfigContextImpl configContext, List<BiConsumer<String, ConfigNode>> listeners, Supplier<Optional<ConfigNode.ObjectNode>> reloader, ConfigSource configSource, WatchableSource<Object> watchable, ChangeWatcher<Object> changeWatcher) {
            this.watchable = watchable;
            this.changeWatcher = changeWatcher;
            this.listener = new WatchableListener(configContext, listeners, reloader, configSource);
        }

        @Override
        public void run() {
            Object target = this.watchable.target();
            this.changeWatcher.start(target, this.listener);
        }
    }

    private static final class PollingStrategyStarter
    implements Runnable {
        private final PollingStrategy pollingStrategy;
        private final PollingStrategyListener listener;

        private PollingStrategyStarter(BuilderImpl.ConfigContextImpl configContext, List<BiConsumer<String, ConfigNode>> listeners, Supplier<Optional<ConfigNode.ObjectNode>> reloader, ConfigSource source, PollableSource<Object> pollable, PollingStrategy pollingStrategy, AtomicReference<Object> lastStamp) {
            this.pollingStrategy = pollingStrategy;
            this.listener = new PollingStrategyListener(configContext, listeners, reloader, source, pollable, lastStamp);
        }

        @Override
        public void run() {
            this.pollingStrategy.start(this.listener);
        }
    }

    private static final class WatchableListener
    implements Consumer<ChangeWatcher.ChangeEvent<Object>> {
        private final BuilderImpl.ConfigContextImpl configContext;
        private final List<BiConsumer<String, ConfigNode>> listeners;
        private final Supplier<Optional<ConfigNode.ObjectNode>> reloader;
        private final ConfigSource configSource;

        private WatchableListener(BuilderImpl.ConfigContextImpl configContext, List<BiConsumer<String, ConfigNode>> listeners, Supplier<Optional<ConfigNode.ObjectNode>> reloader, ConfigSource configSource) {
            this.configContext = configContext;
            this.listeners = listeners;
            this.reloader = reloader;
            this.configSource = configSource;
        }

        @Override
        public void accept(ChangeWatcher.ChangeEvent<Object> change) {
            try {
                Optional<ConfigNode.ObjectNode> objectNode = this.reloader.get();
                if (objectNode.isEmpty()) {
                    if (this.configSource.optional()) {
                        ConfigSourceRuntimeImpl.triggerChanges(this.configContext, this.listeners, objectNode);
                    } else {
                        LOGGER.log(System.Logger.Level.INFO, "Mandatory config source is not available, ignoring change.");
                    }
                } else {
                    ConfigSourceRuntimeImpl.triggerChanges(this.configContext, this.listeners, objectNode);
                }
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.INFO, "Failed to reload config source " + String.valueOf(this.configSource) + ", exception available in finest log level. Change that triggered this event: " + String.valueOf(change));
                LOGGER.log(System.Logger.Level.TRACE, "Failed to reload config source", (Throwable)e);
            }
        }
    }

    private static final class PollingStrategyListener
    implements PollingStrategy.Polled {
        private final BuilderImpl.ConfigContextImpl configContext;
        private final List<BiConsumer<String, ConfigNode>> listeners;
        private final Supplier<Optional<ConfigNode.ObjectNode>> reloader;
        private final ConfigSource source;
        private final PollableSource<Object> pollable;
        private final AtomicReference<Object> lastStamp;

        private PollingStrategyListener(BuilderImpl.ConfigContextImpl configContext, List<BiConsumer<String, ConfigNode>> listeners, Supplier<Optional<ConfigNode.ObjectNode>> reloader, ConfigSource source, PollableSource<Object> pollable, AtomicReference<Object> lastStamp) {
            this.configContext = configContext;
            this.listeners = listeners;
            this.reloader = reloader;
            this.source = source;
            this.pollable = pollable;
            this.lastStamp = lastStamp;
        }

        @Override
        public ChangeEventType poll(Instant when) {
            Object lastStampValue = this.lastStamp.get();
            if (null == lastStampValue || this.pollable.isModified(lastStampValue)) {
                Optional<ConfigNode.ObjectNode> objectNode = this.reloader.get();
                if (objectNode.isEmpty()) {
                    if (this.source.optional()) {
                        ConfigSourceRuntimeImpl.triggerChanges(this.configContext, this.listeners, objectNode);
                    } else {
                        LOGGER.log(System.Logger.Level.INFO, "Mandatory config source is not available, ignoring change.");
                    }
                    return ChangeEventType.DELETED;
                }
                ConfigSourceRuntimeImpl.triggerChanges(this.configContext, this.listeners, objectNode);
                return ChangeEventType.CHANGED;
            }
            return ChangeEventType.UNCHANGED;
        }
    }
}

