/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.helidon.config;

import io.helidon.common.Weight;
import io.helidon.common.Weighted;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;

import io.helidon.inject.api.DependenciesInfo;
import io.helidon.inject.api.ElementKind;
import io.helidon.inject.api.PostConstructMethod;
import io.helidon.inject.api.PreDestroyMethod;
import io.helidon.inject.api.RunLevel;
import io.helidon.inject.api.ServiceInfo;
import io.helidon.inject.runtime.Dependencies;

import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;


import static io.helidon.inject.api.InjectionPointInfo.CONSTRUCTOR;

/**
 * Activator for {@link io.helidon.config.ConfigProducer}.
 */
// @Singleton 
@SuppressWarnings("unchecked")
@io.helidon.common.Generated(value = "io.helidon.inject.tools.ActivatorCreatorDefault", trigger = "io.helidon.config.ConfigProducer")
public class ConfigProducer$$Injection$$Activator
            extends io.helidon.inject.runtime.AbstractServiceProvider<ConfigProducer> {
    private static final ServiceInfo serviceInfo =
        ServiceInfo.builder()
            .serviceTypeName(io.helidon.config.ConfigProducer.class)
            .addExternalContractImplemented(io.helidon.common.config.Config.class)
            .activatorTypeName(ConfigProducer$$Injection$$Activator.class)
            .addScopeTypeName(jakarta.inject.Singleton.class)
            .build();

    /**
     * The global singleton instance for this service provider activator.
     */
    public static final ConfigProducer$$Injection$$Activator INSTANCE = new ConfigProducer$$Injection$$Activator();

    /**
     * Default activator constructor.
     */
    protected ConfigProducer$$Injection$$Activator() {
        serviceInfo(serviceInfo);

    }

    /**
     * The service type of the managed service.
     *
     * @return the service type of the managed service
     */
    @Override
    public Class<?> serviceType() {
        return io.helidon.config.ConfigProducer.class;
    }

    @Override
    public DependenciesInfo dependencies() {
        DependenciesInfo deps = Dependencies.builder(io.helidon.config.ConfigProducer.class)
                .add(CONSTRUCTOR, io.helidon.config.spi.ConfigSource.class, ElementKind.CONSTRUCTOR, 1, AccessModifier.PACKAGE_PRIVATE).elemOffset(1).ipName("serviceProviders").ipType(io.helidon.common.types.TypeName.create(java.util.List.class)).listWrapped().providerWrapped()
                .build();
        return Dependencies.combine(super.dependencies(), deps);
    }

    @Override
    protected ConfigProducer createServiceProvider(Map<String, Object> deps) { 
        java.util.List<jakarta.inject.Provider<io.helidon.config.spi.ConfigSource>> serviceProviders = (java.util.List<jakarta.inject.Provider<io.helidon.config.spi.ConfigSource>>) get(deps, "io.helidon.config.<init>|1(1)");
        return new io.helidon.config.ConfigProducer(serviceProviders);
    }

}