/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.helidon.config;

import io.helidon.inject.api.ModuleComponent;
import io.helidon.inject.api.ServiceBinder;

import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;

/**
 * Generated ModuleComponent.
 */
@io.helidon.common.Generated(value = "io.helidon.inject.tools.ActivatorCreatorDefault", trigger = "io.helidon.inject.tools.ActivatorCreatorDefault")
@Singleton @Named(Injection$$Module.NAME)
public final class Injection$$Module implements ModuleComponent { 
    static final String NAME = "io.helidon.config";

    /**
     * Service loader based constructor.
     *
     * @deprecated this is a Java ServiceLoader implementation and the constructor should not be used directly
     */
    @Deprecated
    public Injection$$Module() {
    }

    @Override
    public Optional<String> named() {
        return Optional.of(NAME);
    }

    @Override
    public String toString() {
        return NAME + ":" + getClass().getName();
    }

    @Override
    public void configure(ServiceBinder binder) {
        binder.bind(io.helidon.config.ConfigProducer$$Injection$$Activator.INSTANCE);

    }

}