/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.OverrideConfigFilter;
import io.helidon.config.OverrideSources;
import io.helidon.config.ProviderImpl;
import io.helidon.config.spi.ChangeEventType;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

class OverrideSourceRuntime {
    private static final System.Logger LOGGER = System.getLogger(OverrideSourceRuntime.class.getName());
    private final OverrideReloader reloader;
    private final Runnable changesRunnable;
    private final OverrideSource source;
    private final boolean changesSupported;
    private final AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData = new AtomicReference(List.of());
    private final AtomicReference<Runnable> changeListener = new AtomicReference();
    private boolean changesStarted = false;
    private boolean dataLoaded = false;

    OverrideSourceRuntime(OverrideSource overrideSource) {
        PollableSource pollable;
        Optional<PollingStrategy> pollingStrategy;
        WatchableSource watchable;
        Optional<ChangeWatcher<Object>> changeWatcher;
        this.source = overrideSource;
        AtomicReference<Object> lastStamp = new AtomicReference<Object>();
        this.reloader = new OverrideReloader(lastStamp, overrideSource);
        boolean changesSupported = false;
        Runnable changesRunnable = null;
        if (overrideSource instanceof WatchableSource && (changeWatcher = (watchable = (WatchableSource)((Object)this.source)).changeWatcher()).isPresent()) {
            changesSupported = true;
            changesRunnable = new WatchableChangesStarter(this.lastData, this.reloader, this.source, watchable, changeWatcher.get(), this.changeListener);
        }
        if (!changesSupported && overrideSource instanceof PollableSource && (pollingStrategy = (pollable = (PollableSource)((Object)this.source)).pollingStrategy()).isPresent()) {
            changesSupported = true;
            changesRunnable = new PollingStrategyStarter(this.lastData, this.reloader, this.source, pollable, pollingStrategy.get(), lastStamp, this.changeListener);
        }
        this.changesRunnable = changesRunnable;
        this.changesSupported = changesSupported;
    }

    static OverrideSourceRuntime empty() {
        return new OverrideSourceRuntime(OverrideSources.empty());
    }

    void addFilter(ProviderImpl.ChainConfigFilter targetFilter) {
        if (!this.dataLoaded) {
            this.initialLoad();
        }
        if (!this.source.equals(OverrideSources.empty())) {
            List<Map.Entry<Predicate<Config.Key>, String>> data = this.lastData.get();
            OverrideConfigFilter filter = new OverrideConfigFilter(() -> data);
            targetFilter.addFilter(filter);
        }
    }

    void startChanges() {
        if (!this.changesStarted && this.dataLoaded && this.changesSupported) {
            this.changesStarted = true;
            this.changesRunnable.run();
        }
    }

    public String toString() {
        return "Runtime for " + String.valueOf(this.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverrideSourceRuntime that = (OverrideSourceRuntime)o;
        return this.source.equals(that.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialLoad() {
        OverrideSource overrideSource = this.source;
        synchronized (overrideSource) {
            if (this.dataLoaded) {
                throw new ConfigException("Attempting to load a single override source multiple times. This is a bug");
            }
            Optional loadedData = this.source.retryPolicy().map(policy -> policy.execute(this.reloader)).orElseGet(this.reloader);
            if (loadedData.isEmpty() && !this.source.optional()) {
                throw new ConfigException("Cannot load data from mandatory source: " + String.valueOf(this.source));
            }
            this.lastData.set(loadedData.map(OverrideSource.OverrideData::data).orElseGet(List::of));
            this.dataLoaded = true;
        }
    }

    public String description() {
        return this.source.description();
    }

    private static void setData(AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData, Optional<OverrideSource.OverrideData> data, AtomicReference<Runnable> changeListener) {
        lastData.set(data.map(OverrideSource.OverrideData::data).orElseGet(List::of));
        Runnable runnable = changeListener.get();
        if (null == runnable) {
            LOGGER.log(System.Logger.Level.TRACE, "Wrong order - change triggered before a change listener is registered in " + OverrideSourceRuntime.class.getName());
        } else {
            runnable.run();
        }
    }

    void changeListener(Runnable listener) {
        this.changeListener.set(listener);
    }

    private static final class OverrideReloader
    implements Supplier<Optional<OverrideSource.OverrideData>> {
        private final AtomicReference<Object> lastStamp;
        private final OverrideSource overrideSource;

        private OverrideReloader(AtomicReference<Object> lastStamp, OverrideSource overrideSource) {
            this.lastStamp = lastStamp;
            this.overrideSource = overrideSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<OverrideSource.OverrideData> get() {
            OverrideSource overrideSource = this.overrideSource;
            synchronized (overrideSource) {
                return this.overrideSource.load().map(content -> {
                    this.lastStamp.set(content.stamp().orElse(null));
                    return content.data();
                });
            }
        }
    }

    private static final class WatchableChangesStarter
    implements Runnable {
        private final WatchableSource<Object> watchable;
        private final WatchableListener listener;
        private final ChangeWatcher<Object> changeWatcher;

        private WatchableChangesStarter(AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData, OverrideReloader reloader, OverrideSource source, WatchableSource<Object> watchable, ChangeWatcher<Object> changeWatcher, AtomicReference<Runnable> changeListener) {
            this.watchable = watchable;
            this.changeWatcher = changeWatcher;
            this.listener = new WatchableListener(lastData, reloader, source, changeListener);
        }

        @Override
        public void run() {
            Object target = this.watchable.target();
            this.changeWatcher.start(target, this.listener);
        }
    }

    private static final class PollingStrategyStarter
    implements Runnable {
        private final PollingStrategy pollingStrategy;
        private final PollingStrategyListener listener;

        private PollingStrategyStarter(AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData, OverrideReloader reloader, OverrideSource source, PollableSource<Object> pollable, PollingStrategy pollingStrategy, AtomicReference<Object> lastStamp, AtomicReference<Runnable> changeListener) {
            this.pollingStrategy = pollingStrategy;
            this.listener = new PollingStrategyListener(lastData, reloader, source, pollable, lastStamp, changeListener);
        }

        @Override
        public void run() {
            this.pollingStrategy.start(this.listener);
        }
    }

    private static final class WatchableListener
    implements Consumer<ChangeWatcher.ChangeEvent<Object>> {
        private final AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData;
        private final OverrideReloader reloader;
        private final OverrideSource source;
        private final AtomicReference<Runnable> changeListener;

        private WatchableListener(AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData, OverrideReloader reloader, OverrideSource source, AtomicReference<Runnable> changeListener) {
            this.lastData = lastData;
            this.reloader = reloader;
            this.source = source;
            this.changeListener = changeListener;
        }

        @Override
        public void accept(ChangeWatcher.ChangeEvent<Object> change) {
            try {
                Object overrideData = this.reloader.get();
                if (((Optional)overrideData).isEmpty()) {
                    if (this.source.optional()) {
                        OverrideSourceRuntime.setData(this.lastData, (Optional<OverrideSource.OverrideData>)overrideData, this.changeListener);
                    } else {
                        LOGGER.log(System.Logger.Level.INFO, "Mandatory config source is not available, ignoring change.");
                    }
                } else {
                    OverrideSourceRuntime.setData(this.lastData, (Optional<OverrideSource.OverrideData>)overrideData, this.changeListener);
                }
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.INFO, "Failed to reload config source " + String.valueOf(this.source) + ", exception available in finest log level. Change that triggered this event: " + String.valueOf(change));
                LOGGER.log(System.Logger.Level.TRACE, "Failed to reload config source", (Throwable)e);
            }
        }
    }

    private static final class PollingStrategyListener
    implements PollingStrategy.Polled {
        private final AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData;
        private final Supplier<Optional<OverrideSource.OverrideData>> reloader;
        private final OverrideSource source;
        private final PollableSource<Object> pollable;
        private final AtomicReference<Object> lastStamp;
        private final AtomicReference<Runnable> changeListener;

        private PollingStrategyListener(AtomicReference<List<Map.Entry<Predicate<Config.Key>, String>>> lastData, OverrideReloader reloader, OverrideSource source, PollableSource<Object> pollable, AtomicReference<Object> lastStamp, AtomicReference<Runnable> changeListener) {
            this.lastData = lastData;
            this.reloader = reloader;
            this.source = source;
            this.pollable = pollable;
            this.lastStamp = lastStamp;
            this.changeListener = changeListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChangeEventType poll(Instant when) {
            Object lastStampValue = this.lastStamp.get();
            PollableSource<Object> pollableSource = this.pollable;
            synchronized (pollableSource) {
                if (null == lastStampValue || this.pollable.isModified(lastStampValue)) {
                    Optional<OverrideSource.OverrideData> overrideData = this.reloader.get();
                    if (overrideData.isEmpty()) {
                        if (this.source.optional()) {
                            OverrideSourceRuntime.setData(this.lastData, overrideData, this.changeListener);
                        } else {
                            LOGGER.log(System.Logger.Level.INFO, "Mandatory config source is not available, ignoring change.");
                        }
                        return ChangeEventType.DELETED;
                    }
                    OverrideSourceRuntime.setData(this.lastData, overrideData, this.changeListener);
                    return ChangeEventType.CHANGED;
                }
            }
            return ChangeEventType.UNCHANGED;
        }
    }
}

