/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Async;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

class AsyncImpl
implements Async {
    private final LazyValue<? extends ExecutorService> executor;

    AsyncImpl(Async.Builder builder) {
        this.executor = LazyValue.create(builder.executor());
    }

    @Override
    public <T> Single<T> invoke(Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        AsyncTask<T> task = new AsyncTask<T>(supplier, future);
        try {
            ((ExecutorService)this.executor.get()).submit(task);
        }
        catch (Throwable e) {
            return Single.error((Throwable)e);
        }
        return Single.create(future);
    }

    static final class DefaultAsyncInstance {
        private static final Async INSTANCE = Async.builder().build();

        DefaultAsyncInstance() {
        }

        static Async instance() {
            return INSTANCE;
        }
    }

    private static class AsyncTask<T>
    implements Runnable {
        private final Supplier<T> supplier;
        private final CompletableFuture<T> future;

        private AsyncTask(Supplier<T> supplier, CompletableFuture<T> future) {
            this.supplier = supplier;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                T result = this.supplier.get();
                this.future.complete(result);
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }
    }
}

