/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.BulkheadException;
import io.helidon.faulttolerance.DelayedTask;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import java.util.logging.Logger;

class BulkheadImpl
implements Bulkhead {
    private static final Logger LOGGER = Logger.getLogger(BulkheadImpl.class.getName());
    private final LazyValue<? extends ExecutorService> executor;
    private final Queue<DelayedTask<?>> queue;
    private final Semaphore inProgress;
    private final String name;

    BulkheadImpl(Bulkhead.Builder builder) {
        this.executor = builder.executor();
        this.inProgress = new Semaphore(builder.limit(), true);
        this.name = builder.name();
        this.queue = builder.queueLength() == 0 ? new NoQueue() : new LinkedBlockingQueue(builder.queueLength());
    }

    @Override
    public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        return this.invokeTask(DelayedTask.createSingle(supplier));
    }

    @Override
    public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        return this.invokeTask(DelayedTask.createMulti(supplier));
    }

    private <R> R invokeTask(DelayedTask<R> task) {
        if (this.inProgress.tryAcquire()) {
            LOGGER.finest(() -> this.name + " invoke immediate: " + task);
            this.execute(task);
            return task.result();
        }
        if (this.queue.offer(task)) {
            LOGGER.finest(() -> this.name + " enqueue: " + task);
            return task.result();
        }
        LOGGER.finest(() -> this.name + " reject: " + task);
        return task.error(new BulkheadException("Bulkhead queue \"" + this.name + "\" is full"));
    }

    private void execute(DelayedTask<?> task) {
        task.execute().handle((it, throwable) -> {
            LOGGER.finest(() -> this.name + " finished execution: " + task + " (" + (throwable == null ? "success" : "failure") + ")");
            DelayedTask<?> polled = this.queue.poll();
            if (polled != null) {
                LOGGER.finest(() -> this.name + " invoke in executor: " + polled);
                ((ExecutorService)this.executor.get()).submit(() -> this.execute(polled));
            } else {
                LOGGER.finest(() -> this.name + " permit released after: " + task);
                this.inProgress.release();
            }
            return null;
        });
    }

    private static class NoQueue
    extends ArrayDeque<DelayedTask<?>> {
        private NoQueue() {
        }

        @Override
        public boolean offer(DelayedTask delayedTask) {
            return false;
        }

        @Override
        public DelayedTask<?> poll() {
            return null;
        }
    }
}

