/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.CircuitBreakerOpenException;
import io.helidon.faulttolerance.DelayedTask;
import io.helidon.faulttolerance.ErrorChecker;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.ResultWindow;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class CircuitBreakerImpl
implements CircuitBreaker {
    private final LazyValue<? extends ScheduledExecutorService> executor;
    private final long delayMillis;
    private final int successThreshold;
    private final AtomicReference<CircuitBreaker.State> state = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private final ResultWindow results;
    private final AtomicInteger successCounter = new AtomicInteger();
    private final AtomicBoolean halfOpenInProgress = new AtomicBoolean();
    private final AtomicReference<ScheduledFuture<Boolean>> schedule = new AtomicReference();
    private final ErrorChecker errorChecker;

    CircuitBreakerImpl(CircuitBreaker.Builder builder) {
        this.delayMillis = builder.delay().toMillis();
        this.successThreshold = builder.successThreshold();
        this.results = new ResultWindow(builder.volume(), builder.errorRatio());
        this.executor = builder.executor();
        this.errorChecker = ErrorChecker.create(builder.skipOn(), builder.applyOn());
    }

    @Override
    public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        return this.invokeTask(DelayedTask.createMulti(supplier));
    }

    @Override
    public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        return this.invokeTask(DelayedTask.createSingle(supplier));
    }

    private <U> U invokeTask(DelayedTask<U> task) {
        if (this.state.get() == CircuitBreaker.State.CLOSED) {
            CompletionStage<Void> completion = task.execute();
            completion.handle((it, throwable) -> {
                Throwable exception = FaultTolerance.cause(throwable);
                if (exception == null || this.errorChecker.shouldSkip(exception)) {
                    this.results.update(ResultWindow.Result.SUCCESS);
                } else {
                    this.results.update(ResultWindow.Result.FAILURE);
                    if (this.results.shouldOpen() && this.state.compareAndSet(CircuitBreaker.State.CLOSED, CircuitBreaker.State.OPEN)) {
                        this.results.reset();
                        this.scheduleHalf();
                    }
                }
                return it;
            });
            return task.result();
        }
        if (this.state.get() == CircuitBreaker.State.OPEN) {
            return task.error(new CircuitBreakerOpenException("CircuitBreaker is open"));
        }
        if (this.halfOpenInProgress.compareAndSet(false, true)) {
            CompletionStage<Void> result = task.execute();
            result.handle((it, throwable) -> {
                Throwable exception = FaultTolerance.cause(throwable);
                if (exception == null || this.errorChecker.shouldSkip(exception)) {
                    int successes = this.successCounter.incrementAndGet();
                    if (successes >= this.successThreshold) {
                        this.successCounter.set(0);
                        this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED);
                        this.halfOpenInProgress.set(false);
                    }
                    this.halfOpenInProgress.set(false);
                } else {
                    this.successCounter.set(0);
                    this.state.set(CircuitBreaker.State.OPEN);
                    this.halfOpenInProgress.set(false);
                    this.scheduleHalf();
                }
                return it;
            });
            return task.result();
        }
        return task.error(new CircuitBreakerOpenException("CircuitBreaker is half open, parallel execution in progress"));
    }

    private void scheduleHalf() {
        this.schedule.set(((ScheduledExecutorService)this.executor.get()).schedule(() -> {
            this.state.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN);
            this.schedule.set(null);
            return true;
        }, this.delayMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    public CircuitBreaker.State state() {
        return this.state.get();
    }

    @Override
    public void state(CircuitBreaker.State newState) {
        if (newState == CircuitBreaker.State.CLOSED) {
            if (this.state.get() == CircuitBreaker.State.CLOSED) {
                this.resetCounters();
                return;
            }
            ScheduledFuture future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
            this.state.set(CircuitBreaker.State.CLOSED);
        } else if (newState == CircuitBreaker.State.OPEN) {
            this.state.set(CircuitBreaker.State.OPEN);
            ScheduledFuture future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
        } else {
            this.resetCounters();
        }
    }

    private void resetCounters() {
        this.results.reset();
        this.successCounter.set(0);
    }
}

